/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioOnlyHlsSettingsMarshaller {
    private static final MarshallingInfo<String> AUDIOGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioGroupId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AUDIOONLYIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioOnlyImage").isBinary(false).build();
    private static final MarshallingInfo<String> AUDIOTRACKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioTrackType").isBinary(false).build();
    private static final AudioOnlyHlsSettingsMarshaller INSTANCE = new AudioOnlyHlsSettingsMarshaller();

    private AudioOnlyHlsSettingsMarshaller() {
    }

    public static AudioOnlyHlsSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioOnlyHlsSettings audioOnlyHlsSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)audioOnlyHlsSettings, (String)"audioOnlyHlsSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)audioOnlyHlsSettings.audioGroupId(), AUDIOGROUPID_BINDING);
            protocolMarshaller.marshall((Object)audioOnlyHlsSettings.audioOnlyImage(), AUDIOONLYIMAGE_BINDING);
            protocolMarshaller.marshall((Object)audioOnlyHlsSettings.audioTrackTypeAsString(), AUDIOTRACKTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

