/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.AudioCodecSettings;
import software.amazon.awssdk.services.medialive.transform.AacSettingsUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.Ac3SettingsUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.Eac3SettingsUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.Mp2SettingsUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.PassThroughSettingsUnmarshaller;

public class AudioCodecSettingsUnmarshaller
implements Unmarshaller<AudioCodecSettings, JsonUnmarshallerContext> {
    private static final AudioCodecSettingsUnmarshaller INSTANCE = new AudioCodecSettingsUnmarshaller();

    public AudioCodecSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        AudioCodecSettings.Builder audioCodecSettingsBuilder = AudioCodecSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("aacSettings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.aacSettings(AacSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ac3Settings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.ac3Settings(Ac3SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("eac3Settings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.eac3Settings(Eac3SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("mp2Settings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.mp2Settings(Mp2SettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("passThroughSettings", targetDepth)) {
                    context.nextToken();
                    audioCodecSettingsBuilder.passThroughSettings(PassThroughSettingsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AudioCodecSettings)audioCodecSettingsBuilder.build();
    }

    public static AudioCodecSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

