/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioCodecSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioCodecSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> AACSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("aacSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AC3SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ac3Settings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EAC3SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eac3Settings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MP2SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mp2Settings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PASSTHROUGHSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passThroughSettings").isBinary(false).build();
    private static final AudioCodecSettingsMarshaller INSTANCE = new AudioCodecSettingsMarshaller();

    private AudioCodecSettingsMarshaller() {
    }

    public static AudioCodecSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioCodecSettings audioCodecSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)audioCodecSettings, (String)"audioCodecSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)audioCodecSettings.aacSettings(), AACSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.ac3Settings(), AC3SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.eac3Settings(), EAC3SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.mp2Settings(), MP2SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioCodecSettings.passThroughSettings(), PASSTHROUGHSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

