/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.AudioChannelMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioChannelMappingMarshaller {
    private static final MarshallingInfo<List> INPUTCHANNELLEVELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputChannelLevels").isBinary(false).build();
    private static final MarshallingInfo<Integer> OUTPUTCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputChannel").isBinary(false).build();
    private static final AudioChannelMappingMarshaller INSTANCE = new AudioChannelMappingMarshaller();

    private AudioChannelMappingMarshaller() {
    }

    public static AudioChannelMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioChannelMapping audioChannelMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)audioChannelMapping, (String)"audioChannelMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(audioChannelMapping.inputChannelLevels(), INPUTCHANNELLEVELS_BINDING);
            protocolMarshaller.marshall((Object)audioChannelMapping.outputChannel(), OUTPUTCHANNEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

