/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.AacSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AacSettingsMarshaller {
    private static final MarshallingInfo<Double> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputType").isBinary(false).build();
    private static final MarshallingInfo<String> PROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("profile").isBinary(false).build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").isBinary(false).build();
    private static final MarshallingInfo<String> RAWFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rawFormat").isBinary(false).build();
    private static final MarshallingInfo<Double> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").isBinary(false).build();
    private static final MarshallingInfo<String> SPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spec").isBinary(false).build();
    private static final MarshallingInfo<String> VBRQUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vbrQuality").isBinary(false).build();
    private static final AacSettingsMarshaller INSTANCE = new AacSettingsMarshaller();

    private AacSettingsMarshaller() {
    }

    public static AacSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AacSettings aacSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)aacSettings, (String)"aacSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)aacSettings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.codingModeAsString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.inputTypeAsString(), INPUTTYPE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.profileAsString(), PROFILE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.rateControlModeAsString(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.rawFormatAsString(), RAWFORMAT_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.sampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.specAsString(), SPEC_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.vbrQualityAsString(), VBRQUALITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

