/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.VideoCodecSettings;
import software.amazon.awssdk.services.medialive.model.VideoDescriptionRespondToAfd;
import software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior;
import software.amazon.awssdk.services.medialive.transform.VideoDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VideoDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, VideoDescription> {
    private final VideoCodecSettings codecSettings;
    private final Integer height;
    private final String name;
    private final String respondToAfd;
    private final String scalingBehavior;
    private final Integer sharpness;
    private final Integer width;

    private VideoDescription(BuilderImpl builder) {
        this.codecSettings = builder.codecSettings;
        this.height = builder.height;
        this.name = builder.name;
        this.respondToAfd = builder.respondToAfd;
        this.scalingBehavior = builder.scalingBehavior;
        this.sharpness = builder.sharpness;
        this.width = builder.width;
    }

    public VideoCodecSettings codecSettings() {
        return this.codecSettings;
    }

    public Integer height() {
        return this.height;
    }

    public String name() {
        return this.name;
    }

    public VideoDescriptionRespondToAfd respondToAfd() {
        return VideoDescriptionRespondToAfd.fromValue(this.respondToAfd);
    }

    public String respondToAfdAsString() {
        return this.respondToAfd;
    }

    public VideoDescriptionScalingBehavior scalingBehavior() {
        return VideoDescriptionScalingBehavior.fromValue(this.scalingBehavior);
    }

    public String scalingBehaviorAsString() {
        return this.scalingBehavior;
    }

    public Integer sharpness() {
        return this.sharpness;
    }

    public Integer width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.respondToAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharpness());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoDescription)) {
            return false;
        }
        VideoDescription other = (VideoDescription)obj;
        return Objects.equals(this.codecSettings(), other.codecSettings()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.respondToAfdAsString(), other.respondToAfdAsString()) && Objects.equals(this.scalingBehaviorAsString(), other.scalingBehaviorAsString()) && Objects.equals(this.sharpness(), other.sharpness()) && Objects.equals(this.width(), other.width());
    }

    public String toString() {
        return ToString.builder((String)"VideoDescription").add("CodecSettings", (Object)this.codecSettings()).add("Height", (Object)this.height()).add("Name", (Object)this.name()).add("RespondToAfd", (Object)this.respondToAfdAsString()).add("ScalingBehavior", (Object)this.scalingBehaviorAsString()).add("Sharpness", (Object)this.sharpness()).add("Width", (Object)this.width()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodecSettings": {
                return Optional.of(clazz.cast(this.codecSettings()));
            }
            case "Height": {
                return Optional.of(clazz.cast(this.height()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "RespondToAfd": {
                return Optional.of(clazz.cast(this.respondToAfdAsString()));
            }
            case "ScalingBehavior": {
                return Optional.of(clazz.cast(this.scalingBehaviorAsString()));
            }
            case "Sharpness": {
                return Optional.of(clazz.cast(this.sharpness()));
            }
            case "Width": {
                return Optional.of(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private VideoCodecSettings codecSettings;
        private Integer height;
        private String name;
        private String respondToAfd;
        private String scalingBehavior;
        private Integer sharpness;
        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoDescription model) {
            this.codecSettings(model.codecSettings);
            this.height(model.height);
            this.name(model.name);
            this.respondToAfd(model.respondToAfd);
            this.scalingBehavior(model.scalingBehavior);
            this.sharpness(model.sharpness);
            this.width(model.width);
        }

        public final VideoCodecSettings.Builder getCodecSettings() {
            return this.codecSettings != null ? this.codecSettings.toBuilder() : null;
        }

        @Override
        public final Builder codecSettings(VideoCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final void setCodecSettings(VideoCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        public final Integer getHeight() {
            return this.height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRespondToAfd() {
            return this.respondToAfd;
        }

        @Override
        public final Builder respondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
            return this;
        }

        @Override
        public final Builder respondToAfd(VideoDescriptionRespondToAfd respondToAfd) {
            this.respondToAfd(respondToAfd.toString());
            return this;
        }

        public final void setRespondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
        }

        public final String getScalingBehavior() {
            return this.scalingBehavior;
        }

        @Override
        public final Builder scalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
            return this;
        }

        @Override
        public final Builder scalingBehavior(VideoDescriptionScalingBehavior scalingBehavior) {
            this.scalingBehavior(scalingBehavior.toString());
            return this;
        }

        public final void setScalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
        }

        public final Integer getSharpness() {
            return this.sharpness;
        }

        @Override
        public final Builder sharpness(Integer sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final void setSharpness(Integer sharpness) {
            this.sharpness = sharpness;
        }

        public final Integer getWidth() {
            return this.width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        public VideoDescription build() {
            return new VideoDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VideoDescription> {
        public Builder codecSettings(VideoCodecSettings var1);

        default public Builder codecSettings(Consumer<VideoCodecSettings.Builder> codecSettings) {
            return this.codecSettings((VideoCodecSettings)((VideoCodecSettings.Builder)VideoCodecSettings.builder().apply(codecSettings)).build());
        }

        public Builder height(Integer var1);

        public Builder name(String var1);

        public Builder respondToAfd(String var1);

        public Builder respondToAfd(VideoDescriptionRespondToAfd var1);

        public Builder scalingBehavior(String var1);

        public Builder scalingBehavior(VideoDescriptionScalingBehavior var1);

        public Builder sharpness(Integer var1);

        public Builder width(Integer var1);
    }
}

