/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.transform.ValidationErrorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidationError
implements StructuredPojo,
ToCopyableBuilder<Builder, ValidationError> {
    private final String elementPath;
    private final String errorMessage;

    private ValidationError(BuilderImpl builder) {
        this.elementPath = builder.elementPath;
        this.errorMessage = builder.errorMessage;
    }

    public String elementPath() {
        return this.elementPath;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elementPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError)obj;
        return Objects.equals(this.elementPath(), other.elementPath()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        return ToString.builder((String)"ValidationError").add("ElementPath", (Object)this.elementPath()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElementPath": {
                return Optional.of(clazz.cast(this.elementPath()));
            }
            case "ErrorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValidationErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String elementPath;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationError model) {
            this.elementPath(model.elementPath);
            this.errorMessage(model.errorMessage);
        }

        public final String getElementPath() {
            return this.elementPath;
        }

        @Override
        public final Builder elementPath(String elementPath) {
            this.elementPath = elementPath;
            return this;
        }

        public final void setElementPath(String elementPath) {
            this.elementPath = elementPath;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public ValidationError build() {
            return new ValidationError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidationError> {
        public Builder elementPath(String var1);

        public Builder errorMessage(String var1);
    }
}

