/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.TtmlDestinationStyleControl;
import software.amazon.awssdk.services.medialive.transform.TtmlDestinationSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TtmlDestinationSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, TtmlDestinationSettings> {
    private final String styleControl;

    private TtmlDestinationSettings(BuilderImpl builder) {
        this.styleControl = builder.styleControl;
    }

    public TtmlDestinationStyleControl styleControl() {
        return TtmlDestinationStyleControl.fromValue(this.styleControl);
    }

    public String styleControlAsString() {
        return this.styleControl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.styleControlAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TtmlDestinationSettings)) {
            return false;
        }
        TtmlDestinationSettings other = (TtmlDestinationSettings)obj;
        return Objects.equals(this.styleControlAsString(), other.styleControlAsString());
    }

    public String toString() {
        return ToString.builder((String)"TtmlDestinationSettings").add("StyleControl", (Object)this.styleControlAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StyleControl": {
                return Optional.of(clazz.cast(this.styleControlAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TtmlDestinationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String styleControl;

        private BuilderImpl() {
        }

        private BuilderImpl(TtmlDestinationSettings model) {
            this.styleControl(model.styleControl);
        }

        public final String getStyleControl() {
            return this.styleControl;
        }

        @Override
        public final Builder styleControl(String styleControl) {
            this.styleControl = styleControl;
            return this;
        }

        @Override
        public final Builder styleControl(TtmlDestinationStyleControl styleControl) {
            this.styleControl(styleControl.toString());
            return this;
        }

        public final void setStyleControl(String styleControl) {
            this.styleControl = styleControl;
        }

        public TtmlDestinationSettings build() {
            return new TtmlDestinationSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TtmlDestinationSettings> {
        public Builder styleControl(String var1);

        public Builder styleControl(TtmlDestinationStyleControl var1);
    }
}

