/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.TimecodeConfigSource;
import software.amazon.awssdk.services.medialive.transform.TimecodeConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimecodeConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, TimecodeConfig> {
    private final String source;
    private final Integer syncThreshold;

    private TimecodeConfig(BuilderImpl builder) {
        this.source = builder.source;
        this.syncThreshold = builder.syncThreshold;
    }

    public TimecodeConfigSource source() {
        return TimecodeConfigSource.fromValue(this.source);
    }

    public String sourceAsString() {
        return this.source;
    }

    public Integer syncThreshold() {
        return this.syncThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeConfig)) {
            return false;
        }
        TimecodeConfig other = (TimecodeConfig)obj;
        return Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.syncThreshold(), other.syncThreshold());
    }

    public String toString() {
        return ToString.builder((String)"TimecodeConfig").add("Source", (Object)this.sourceAsString()).add("SyncThreshold", (Object)this.syncThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.of(clazz.cast(this.sourceAsString()));
            }
            case "SyncThreshold": {
                return Optional.of(clazz.cast(this.syncThreshold()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimecodeConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private Integer syncThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeConfig model) {
            this.source(model.source);
            this.syncThreshold(model.syncThreshold);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(TimecodeConfigSource source) {
            this.source(source.toString());
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Integer getSyncThreshold() {
            return this.syncThreshold;
        }

        @Override
        public final Builder syncThreshold(Integer syncThreshold) {
            this.syncThreshold = syncThreshold;
            return this;
        }

        public final void setSyncThreshold(Integer syncThreshold) {
            this.syncThreshold = syncThreshold;
        }

        public TimecodeConfig build() {
            return new TimecodeConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimecodeConfig> {
        public Builder source(String var1);

        public Builder source(TimecodeConfigSource var1);

        public Builder syncThreshold(Integer var1);
    }
}

