/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.services.medialive.transform.StaticKeySettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StaticKeySettings
implements StructuredPojo,
ToCopyableBuilder<Builder, StaticKeySettings> {
    private final InputLocation keyProviderServer;
    private final String staticKeyValue;

    private StaticKeySettings(BuilderImpl builder) {
        this.keyProviderServer = builder.keyProviderServer;
        this.staticKeyValue = builder.staticKeyValue;
    }

    public InputLocation keyProviderServer() {
        return this.keyProviderServer;
    }

    public String staticKeyValue() {
        return this.staticKeyValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyProviderServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticKeyValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticKeySettings)) {
            return false;
        }
        StaticKeySettings other = (StaticKeySettings)obj;
        return Objects.equals(this.keyProviderServer(), other.keyProviderServer()) && Objects.equals(this.staticKeyValue(), other.staticKeyValue());
    }

    public String toString() {
        return ToString.builder((String)"StaticKeySettings").add("KeyProviderServer", (Object)this.keyProviderServer()).add("StaticKeyValue", (Object)this.staticKeyValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyProviderServer": {
                return Optional.of(clazz.cast(this.keyProviderServer()));
            }
            case "StaticKeyValue": {
                return Optional.of(clazz.cast(this.staticKeyValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StaticKeySettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private InputLocation keyProviderServer;
        private String staticKeyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticKeySettings model) {
            this.keyProviderServer(model.keyProviderServer);
            this.staticKeyValue(model.staticKeyValue);
        }

        public final InputLocation.Builder getKeyProviderServer() {
            return this.keyProviderServer != null ? this.keyProviderServer.toBuilder() : null;
        }

        @Override
        public final Builder keyProviderServer(InputLocation keyProviderServer) {
            this.keyProviderServer = keyProviderServer;
            return this;
        }

        public final void setKeyProviderServer(InputLocation.BuilderImpl keyProviderServer) {
            this.keyProviderServer = keyProviderServer != null ? keyProviderServer.build() : null;
        }

        public final String getStaticKeyValue() {
            return this.staticKeyValue;
        }

        @Override
        public final Builder staticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
            return this;
        }

        public final void setStaticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
        }

        public StaticKeySettings build() {
            return new StaticKeySettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StaticKeySettings> {
        public Builder keyProviderServer(InputLocation var1);

        default public Builder keyProviderServer(Consumer<InputLocation.Builder> keyProviderServer) {
            return this.keyProviderServer((InputLocation)((InputLocation.Builder)InputLocation.builder().apply(keyProviderServer)).build());
        }

        public Builder staticKeyValue(String var1);
    }
}

