/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.M3u8Settings;
import software.amazon.awssdk.services.medialive.transform.StandardHlsSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StandardHlsSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, StandardHlsSettings> {
    private final String audioRenditionSets;
    private final M3u8Settings m3u8Settings;

    private StandardHlsSettings(BuilderImpl builder) {
        this.audioRenditionSets = builder.audioRenditionSets;
        this.m3u8Settings = builder.m3u8Settings;
    }

    public String audioRenditionSets() {
        return this.audioRenditionSets;
    }

    public M3u8Settings m3u8Settings() {
        return this.m3u8Settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.m3u8Settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardHlsSettings)) {
            return false;
        }
        StandardHlsSettings other = (StandardHlsSettings)obj;
        return Objects.equals(this.audioRenditionSets(), other.audioRenditionSets()) && Objects.equals(this.m3u8Settings(), other.m3u8Settings());
    }

    public String toString() {
        return ToString.builder((String)"StandardHlsSettings").add("AudioRenditionSets", (Object)this.audioRenditionSets()).add("M3u8Settings", (Object)this.m3u8Settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioRenditionSets": {
                return Optional.of(clazz.cast(this.audioRenditionSets()));
            }
            case "M3u8Settings": {
                return Optional.of(clazz.cast(this.m3u8Settings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StandardHlsSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioRenditionSets;
        private M3u8Settings m3u8Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardHlsSettings model) {
            this.audioRenditionSets(model.audioRenditionSets);
            this.m3u8Settings(model.m3u8Settings);
        }

        public final String getAudioRenditionSets() {
            return this.audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        public final M3u8Settings.Builder getM3u8Settings() {
            return this.m3u8Settings != null ? this.m3u8Settings.toBuilder() : null;
        }

        @Override
        public final Builder m3u8Settings(M3u8Settings m3u8Settings) {
            this.m3u8Settings = m3u8Settings;
            return this;
        }

        public final void setM3u8Settings(M3u8Settings.BuilderImpl m3u8Settings) {
            this.m3u8Settings = m3u8Settings != null ? m3u8Settings.build() : null;
        }

        public StandardHlsSettings build() {
            return new StandardHlsSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StandardHlsSettings> {
        public Builder audioRenditionSets(String var1);

        public Builder m3u8Settings(M3u8Settings var1);

        default public Builder m3u8Settings(Consumer<M3u8Settings.Builder> m3u8Settings) {
            return this.m3u8Settings((M3u8Settings)((M3u8Settings.Builder)M3u8Settings.builder().apply(m3u8Settings)).build());
        }
    }
}

