/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioChannelMapping;
import software.amazon.awssdk.services.medialive.model.ListOfAudioChannelMappingCopier;
import software.amazon.awssdk.services.medialive.transform.RemixSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemixSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, RemixSettings> {
    private final List<AudioChannelMapping> channelMappings;
    private final Integer channelsIn;
    private final Integer channelsOut;

    private RemixSettings(BuilderImpl builder) {
        this.channelMappings = builder.channelMappings;
        this.channelsIn = builder.channelsIn;
        this.channelsOut = builder.channelsOut;
    }

    public List<AudioChannelMapping> channelMappings() {
        return this.channelMappings;
    }

    public Integer channelsIn() {
        return this.channelsIn;
    }

    public Integer channelsOut() {
        return this.channelsOut;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsOut());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemixSettings)) {
            return false;
        }
        RemixSettings other = (RemixSettings)obj;
        return Objects.equals(this.channelMappings(), other.channelMappings()) && Objects.equals(this.channelsIn(), other.channelsIn()) && Objects.equals(this.channelsOut(), other.channelsOut());
    }

    public String toString() {
        return ToString.builder((String)"RemixSettings").add("ChannelMappings", this.channelMappings()).add("ChannelsIn", (Object)this.channelsIn()).add("ChannelsOut", (Object)this.channelsOut()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelMappings": {
                return Optional.of(clazz.cast(this.channelMappings()));
            }
            case "ChannelsIn": {
                return Optional.of(clazz.cast(this.channelsIn()));
            }
            case "ChannelsOut": {
                return Optional.of(clazz.cast(this.channelsOut()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemixSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioChannelMapping> channelMappings;
        private Integer channelsIn;
        private Integer channelsOut;

        private BuilderImpl() {
        }

        private BuilderImpl(RemixSettings model) {
            this.channelMappings(model.channelMappings);
            this.channelsIn(model.channelsIn);
            this.channelsOut(model.channelsOut);
        }

        public final Collection<AudioChannelMapping.Builder> getChannelMappings() {
            return this.channelMappings != null ? (Collection)this.channelMappings.stream().map(AudioChannelMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder channelMappings(Collection<AudioChannelMapping> channelMappings) {
            this.channelMappings = ListOfAudioChannelMappingCopier.copy(channelMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMappings(AudioChannelMapping ... channelMappings) {
            this.channelMappings(Arrays.asList(channelMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMappings(Consumer<AudioChannelMapping.Builder> ... channelMappings) {
            this.channelMappings(Stream.of(channelMappings).map(c -> (AudioChannelMapping)((AudioChannelMapping.Builder)AudioChannelMapping.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChannelMappings(Collection<AudioChannelMapping.BuilderImpl> channelMappings) {
            this.channelMappings = ListOfAudioChannelMappingCopier.copyFromBuilder(channelMappings);
        }

        public final Integer getChannelsIn() {
            return this.channelsIn;
        }

        @Override
        public final Builder channelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
            return this;
        }

        public final void setChannelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
        }

        public final Integer getChannelsOut() {
            return this.channelsOut;
        }

        @Override
        public final Builder channelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
            return this;
        }

        public final void setChannelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
        }

        public RemixSettings build() {
            return new RemixSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemixSettings> {
        public Builder channelMappings(Collection<AudioChannelMapping> var1);

        public Builder channelMappings(AudioChannelMapping ... var1);

        public Builder channelMappings(Consumer<AudioChannelMapping.Builder> ... var1);

        public Builder channelsIn(Integer var1);

        public Builder channelsOut(Integer var1);
    }
}

