/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.ArchiveGroupSettings;
import software.amazon.awssdk.services.medialive.model.HlsGroupSettings;
import software.amazon.awssdk.services.medialive.model.MsSmoothGroupSettings;
import software.amazon.awssdk.services.medialive.model.UdpGroupSettings;
import software.amazon.awssdk.services.medialive.transform.OutputGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutputGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputGroupSettings> {
    private final ArchiveGroupSettings archiveGroupSettings;
    private final HlsGroupSettings hlsGroupSettings;
    private final MsSmoothGroupSettings msSmoothGroupSettings;
    private final UdpGroupSettings udpGroupSettings;

    private OutputGroupSettings(BuilderImpl builder) {
        this.archiveGroupSettings = builder.archiveGroupSettings;
        this.hlsGroupSettings = builder.hlsGroupSettings;
        this.msSmoothGroupSettings = builder.msSmoothGroupSettings;
        this.udpGroupSettings = builder.udpGroupSettings;
    }

    public ArchiveGroupSettings archiveGroupSettings() {
        return this.archiveGroupSettings;
    }

    public HlsGroupSettings hlsGroupSettings() {
        return this.hlsGroupSettings;
    }

    public MsSmoothGroupSettings msSmoothGroupSettings() {
        return this.msSmoothGroupSettings;
    }

    public UdpGroupSettings udpGroupSettings() {
        return this.udpGroupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.msSmoothGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.udpGroupSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroupSettings)) {
            return false;
        }
        OutputGroupSettings other = (OutputGroupSettings)obj;
        return Objects.equals(this.archiveGroupSettings(), other.archiveGroupSettings()) && Objects.equals(this.hlsGroupSettings(), other.hlsGroupSettings()) && Objects.equals(this.msSmoothGroupSettings(), other.msSmoothGroupSettings()) && Objects.equals(this.udpGroupSettings(), other.udpGroupSettings());
    }

    public String toString() {
        return ToString.builder((String)"OutputGroupSettings").add("ArchiveGroupSettings", (Object)this.archiveGroupSettings()).add("HlsGroupSettings", (Object)this.hlsGroupSettings()).add("MsSmoothGroupSettings", (Object)this.msSmoothGroupSettings()).add("UdpGroupSettings", (Object)this.udpGroupSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveGroupSettings": {
                return Optional.of(clazz.cast(this.archiveGroupSettings()));
            }
            case "HlsGroupSettings": {
                return Optional.of(clazz.cast(this.hlsGroupSettings()));
            }
            case "MsSmoothGroupSettings": {
                return Optional.of(clazz.cast(this.msSmoothGroupSettings()));
            }
            case "UdpGroupSettings": {
                return Optional.of(clazz.cast(this.udpGroupSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ArchiveGroupSettings archiveGroupSettings;
        private HlsGroupSettings hlsGroupSettings;
        private MsSmoothGroupSettings msSmoothGroupSettings;
        private UdpGroupSettings udpGroupSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroupSettings model) {
            this.archiveGroupSettings(model.archiveGroupSettings);
            this.hlsGroupSettings(model.hlsGroupSettings);
            this.msSmoothGroupSettings(model.msSmoothGroupSettings);
            this.udpGroupSettings(model.udpGroupSettings);
        }

        public final ArchiveGroupSettings.Builder getArchiveGroupSettings() {
            return this.archiveGroupSettings != null ? this.archiveGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder archiveGroupSettings(ArchiveGroupSettings archiveGroupSettings) {
            this.archiveGroupSettings = archiveGroupSettings;
            return this;
        }

        public final void setArchiveGroupSettings(ArchiveGroupSettings.BuilderImpl archiveGroupSettings) {
            this.archiveGroupSettings = archiveGroupSettings != null ? archiveGroupSettings.build() : null;
        }

        public final HlsGroupSettings.Builder getHlsGroupSettings() {
            return this.hlsGroupSettings != null ? this.hlsGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsGroupSettings(HlsGroupSettings hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings;
            return this;
        }

        public final void setHlsGroupSettings(HlsGroupSettings.BuilderImpl hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings != null ? hlsGroupSettings.build() : null;
        }

        public final MsSmoothGroupSettings.Builder getMsSmoothGroupSettings() {
            return this.msSmoothGroupSettings != null ? this.msSmoothGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder msSmoothGroupSettings(MsSmoothGroupSettings msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings;
            return this;
        }

        public final void setMsSmoothGroupSettings(MsSmoothGroupSettings.BuilderImpl msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings != null ? msSmoothGroupSettings.build() : null;
        }

        public final UdpGroupSettings.Builder getUdpGroupSettings() {
            return this.udpGroupSettings != null ? this.udpGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder udpGroupSettings(UdpGroupSettings udpGroupSettings) {
            this.udpGroupSettings = udpGroupSettings;
            return this;
        }

        public final void setUdpGroupSettings(UdpGroupSettings.BuilderImpl udpGroupSettings) {
            this.udpGroupSettings = udpGroupSettings != null ? udpGroupSettings.build() : null;
        }

        public OutputGroupSettings build() {
            return new OutputGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputGroupSettings> {
        public Builder archiveGroupSettings(ArchiveGroupSettings var1);

        default public Builder archiveGroupSettings(Consumer<ArchiveGroupSettings.Builder> archiveGroupSettings) {
            return this.archiveGroupSettings((ArchiveGroupSettings)((ArchiveGroupSettings.Builder)ArchiveGroupSettings.builder().apply(archiveGroupSettings)).build());
        }

        public Builder hlsGroupSettings(HlsGroupSettings var1);

        default public Builder hlsGroupSettings(Consumer<HlsGroupSettings.Builder> hlsGroupSettings) {
            return this.hlsGroupSettings((HlsGroupSettings)((HlsGroupSettings.Builder)HlsGroupSettings.builder().apply(hlsGroupSettings)).build());
        }

        public Builder msSmoothGroupSettings(MsSmoothGroupSettings var1);

        default public Builder msSmoothGroupSettings(Consumer<MsSmoothGroupSettings.Builder> msSmoothGroupSettings) {
            return this.msSmoothGroupSettings((MsSmoothGroupSettings)((MsSmoothGroupSettings.Builder)MsSmoothGroupSettings.builder().apply(msSmoothGroupSettings)).build());
        }

        public Builder udpGroupSettings(UdpGroupSettings var1);

        default public Builder udpGroupSettings(Consumer<UdpGroupSettings.Builder> udpGroupSettings) {
            return this.udpGroupSettings((UdpGroupSettings)((UdpGroupSettings.Builder)UdpGroupSettings.builder().apply(udpGroupSettings)).build());
        }
    }
}

