/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.ListOfOutputCopier;
import software.amazon.awssdk.services.medialive.model.Output;
import software.amazon.awssdk.services.medialive.model.OutputGroupSettings;
import software.amazon.awssdk.services.medialive.transform.OutputGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutputGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputGroup> {
    private final String name;
    private final OutputGroupSettings outputGroupSettings;
    private final List<Output> outputs;

    private OutputGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.outputGroupSettings = builder.outputGroupSettings;
        this.outputs = builder.outputs;
    }

    public String name() {
        return this.name;
    }

    public OutputGroupSettings outputGroupSettings() {
        return this.outputGroupSettings;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroup)) {
            return false;
        }
        OutputGroup other = (OutputGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.outputGroupSettings(), other.outputGroupSettings()) && Objects.equals(this.outputs(), other.outputs());
    }

    public String toString() {
        return ToString.builder((String)"OutputGroup").add("Name", (Object)this.name()).add("OutputGroupSettings", (Object)this.outputGroupSettings()).add("Outputs", this.outputs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "OutputGroupSettings": {
                return Optional.of(clazz.cast(this.outputGroupSettings()));
            }
            case "Outputs": {
                return Optional.of(clazz.cast(this.outputs()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private OutputGroupSettings outputGroupSettings;
        private List<Output> outputs;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroup model) {
            this.name(model.name);
            this.outputGroupSettings(model.outputGroupSettings);
            this.outputs(model.outputs);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final OutputGroupSettings.Builder getOutputGroupSettings() {
            return this.outputGroupSettings != null ? this.outputGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder outputGroupSettings(OutputGroupSettings outputGroupSettings) {
            this.outputGroupSettings = outputGroupSettings;
            return this;
        }

        public final void setOutputGroupSettings(OutputGroupSettings.BuilderImpl outputGroupSettings) {
            this.outputGroupSettings = outputGroupSettings != null ? outputGroupSettings.build() : null;
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ListOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ListOfOutputCopier.copyFromBuilder(outputs);
        }

        public OutputGroup build() {
            return new OutputGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputGroup> {
        public Builder name(String var1);

        public Builder outputGroupSettings(OutputGroupSettings var1);

        default public Builder outputGroupSettings(Consumer<OutputGroupSettings.Builder> outputGroupSettings) {
            return this.outputGroupSettings((OutputGroupSettings)((OutputGroupSettings.Builder)OutputGroupSettings.builder().apply(outputGroupSettings)).build());
        }

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);
    }
}

