/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsInputSettings;
import software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation;
import software.amazon.awssdk.services.medialive.transform.NetworkInputSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInputSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, NetworkInputSettings> {
    private final HlsInputSettings hlsInputSettings;
    private final String serverValidation;

    private NetworkInputSettings(BuilderImpl builder) {
        this.hlsInputSettings = builder.hlsInputSettings;
        this.serverValidation = builder.serverValidation;
    }

    public HlsInputSettings hlsInputSettings() {
        return this.hlsInputSettings;
    }

    public NetworkInputServerValidation serverValidation() {
        return NetworkInputServerValidation.fromValue(this.serverValidation);
    }

    public String serverValidationAsString() {
        return this.serverValidation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsInputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverValidationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInputSettings)) {
            return false;
        }
        NetworkInputSettings other = (NetworkInputSettings)obj;
        return Objects.equals(this.hlsInputSettings(), other.hlsInputSettings()) && Objects.equals(this.serverValidationAsString(), other.serverValidationAsString());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInputSettings").add("HlsInputSettings", (Object)this.hlsInputSettings()).add("ServerValidation", (Object)this.serverValidationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HlsInputSettings": {
                return Optional.of(clazz.cast(this.hlsInputSettings()));
            }
            case "ServerValidation": {
                return Optional.of(clazz.cast(this.serverValidationAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkInputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private HlsInputSettings hlsInputSettings;
        private String serverValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInputSettings model) {
            this.hlsInputSettings(model.hlsInputSettings);
            this.serverValidation(model.serverValidation);
        }

        public final HlsInputSettings.Builder getHlsInputSettings() {
            return this.hlsInputSettings != null ? this.hlsInputSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsInputSettings(HlsInputSettings hlsInputSettings) {
            this.hlsInputSettings = hlsInputSettings;
            return this;
        }

        public final void setHlsInputSettings(HlsInputSettings.BuilderImpl hlsInputSettings) {
            this.hlsInputSettings = hlsInputSettings != null ? hlsInputSettings.build() : null;
        }

        public final String getServerValidation() {
            return this.serverValidation;
        }

        @Override
        public final Builder serverValidation(String serverValidation) {
            this.serverValidation = serverValidation;
            return this;
        }

        @Override
        public final Builder serverValidation(NetworkInputServerValidation serverValidation) {
            this.serverValidation(serverValidation.toString());
            return this;
        }

        public final void setServerValidation(String serverValidation) {
            this.serverValidation = serverValidation;
        }

        public NetworkInputSettings build() {
            return new NetworkInputSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInputSettings> {
        public Builder hlsInputSettings(HlsInputSettings var1);

        default public Builder hlsInputSettings(Consumer<HlsInputSettings.Builder> hlsInputSettings) {
            return this.hlsInputSettings((HlsInputSettings)((HlsInputSettings.Builder)HlsInputSettings.builder().apply(hlsInputSettings)).build());
        }

        public Builder serverValidation(String var1);

        public Builder serverValidation(NetworkInputServerValidation var1);
    }
}

