/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputLossActionForMsSmoothOut;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.model.SmoothGroupAudioOnlyTimecodeControl;
import software.amazon.awssdk.services.medialive.model.SmoothGroupCertificateMode;
import software.amazon.awssdk.services.medialive.model.SmoothGroupEventIdMode;
import software.amazon.awssdk.services.medialive.model.SmoothGroupEventStopBehavior;
import software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode;
import software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType;
import software.amazon.awssdk.services.medialive.model.SmoothGroupStreamManifestBehavior;
import software.amazon.awssdk.services.medialive.model.SmoothGroupTimestampOffsetMode;
import software.amazon.awssdk.services.medialive.transform.MsSmoothGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MsSmoothGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, MsSmoothGroupSettings> {
    private final String acquisitionPointId;
    private final String audioOnlyTimecodeControl;
    private final String certificateMode;
    private final Integer connectionRetryInterval;
    private final OutputLocationRef destination;
    private final String eventId;
    private final String eventIdMode;
    private final String eventStopBehavior;
    private final Integer filecacheDuration;
    private final Integer fragmentLength;
    private final String inputLossAction;
    private final Integer numRetries;
    private final Integer restartDelay;
    private final String segmentationMode;
    private final Integer sendDelayMs;
    private final String sparseTrackType;
    private final String streamManifestBehavior;
    private final String timestampOffset;
    private final String timestampOffsetMode;

    private MsSmoothGroupSettings(BuilderImpl builder) {
        this.acquisitionPointId = builder.acquisitionPointId;
        this.audioOnlyTimecodeControl = builder.audioOnlyTimecodeControl;
        this.certificateMode = builder.certificateMode;
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.destination = builder.destination;
        this.eventId = builder.eventId;
        this.eventIdMode = builder.eventIdMode;
        this.eventStopBehavior = builder.eventStopBehavior;
        this.filecacheDuration = builder.filecacheDuration;
        this.fragmentLength = builder.fragmentLength;
        this.inputLossAction = builder.inputLossAction;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
        this.segmentationMode = builder.segmentationMode;
        this.sendDelayMs = builder.sendDelayMs;
        this.sparseTrackType = builder.sparseTrackType;
        this.streamManifestBehavior = builder.streamManifestBehavior;
        this.timestampOffset = builder.timestampOffset;
        this.timestampOffsetMode = builder.timestampOffsetMode;
    }

    public String acquisitionPointId() {
        return this.acquisitionPointId;
    }

    public SmoothGroupAudioOnlyTimecodeControl audioOnlyTimecodeControl() {
        return SmoothGroupAudioOnlyTimecodeControl.fromValue(this.audioOnlyTimecodeControl);
    }

    public String audioOnlyTimecodeControlAsString() {
        return this.audioOnlyTimecodeControl;
    }

    public SmoothGroupCertificateMode certificateMode() {
        return SmoothGroupCertificateMode.fromValue(this.certificateMode);
    }

    public String certificateModeAsString() {
        return this.certificateMode;
    }

    public Integer connectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public OutputLocationRef destination() {
        return this.destination;
    }

    public String eventId() {
        return this.eventId;
    }

    public SmoothGroupEventIdMode eventIdMode() {
        return SmoothGroupEventIdMode.fromValue(this.eventIdMode);
    }

    public String eventIdModeAsString() {
        return this.eventIdMode;
    }

    public SmoothGroupEventStopBehavior eventStopBehavior() {
        return SmoothGroupEventStopBehavior.fromValue(this.eventStopBehavior);
    }

    public String eventStopBehaviorAsString() {
        return this.eventStopBehavior;
    }

    public Integer filecacheDuration() {
        return this.filecacheDuration;
    }

    public Integer fragmentLength() {
        return this.fragmentLength;
    }

    public InputLossActionForMsSmoothOut inputLossAction() {
        return InputLossActionForMsSmoothOut.fromValue(this.inputLossAction);
    }

    public String inputLossActionAsString() {
        return this.inputLossAction;
    }

    public Integer numRetries() {
        return this.numRetries;
    }

    public Integer restartDelay() {
        return this.restartDelay;
    }

    public SmoothGroupSegmentationMode segmentationMode() {
        return SmoothGroupSegmentationMode.fromValue(this.segmentationMode);
    }

    public String segmentationModeAsString() {
        return this.segmentationMode;
    }

    public Integer sendDelayMs() {
        return this.sendDelayMs;
    }

    public SmoothGroupSparseTrackType sparseTrackType() {
        return SmoothGroupSparseTrackType.fromValue(this.sparseTrackType);
    }

    public String sparseTrackTypeAsString() {
        return this.sparseTrackType;
    }

    public SmoothGroupStreamManifestBehavior streamManifestBehavior() {
        return SmoothGroupStreamManifestBehavior.fromValue(this.streamManifestBehavior);
    }

    public String streamManifestBehaviorAsString() {
        return this.streamManifestBehavior;
    }

    public String timestampOffset() {
        return this.timestampOffset;
    }

    public SmoothGroupTimestampOffsetMode timestampOffsetMode() {
        return SmoothGroupTimestampOffsetMode.fromValue(this.timestampOffsetMode);
    }

    public String timestampOffsetModeAsString() {
        return this.timestampOffsetMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acquisitionPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyTimecodeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventIdModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStopBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparseTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamManifestBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampOffsetModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MsSmoothGroupSettings)) {
            return false;
        }
        MsSmoothGroupSettings other = (MsSmoothGroupSettings)obj;
        return Objects.equals(this.acquisitionPointId(), other.acquisitionPointId()) && Objects.equals(this.audioOnlyTimecodeControlAsString(), other.audioOnlyTimecodeControlAsString()) && Objects.equals(this.certificateModeAsString(), other.certificateModeAsString()) && Objects.equals(this.connectionRetryInterval(), other.connectionRetryInterval()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventIdModeAsString(), other.eventIdModeAsString()) && Objects.equals(this.eventStopBehaviorAsString(), other.eventStopBehaviorAsString()) && Objects.equals(this.filecacheDuration(), other.filecacheDuration()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.inputLossActionAsString(), other.inputLossActionAsString()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.restartDelay(), other.restartDelay()) && Objects.equals(this.segmentationModeAsString(), other.segmentationModeAsString()) && Objects.equals(this.sendDelayMs(), other.sendDelayMs()) && Objects.equals(this.sparseTrackTypeAsString(), other.sparseTrackTypeAsString()) && Objects.equals(this.streamManifestBehaviorAsString(), other.streamManifestBehaviorAsString()) && Objects.equals(this.timestampOffset(), other.timestampOffset()) && Objects.equals(this.timestampOffsetModeAsString(), other.timestampOffsetModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"MsSmoothGroupSettings").add("AcquisitionPointId", (Object)this.acquisitionPointId()).add("AudioOnlyTimecodeControl", (Object)this.audioOnlyTimecodeControlAsString()).add("CertificateMode", (Object)this.certificateModeAsString()).add("ConnectionRetryInterval", (Object)this.connectionRetryInterval()).add("Destination", (Object)this.destination()).add("EventId", (Object)this.eventId()).add("EventIdMode", (Object)this.eventIdModeAsString()).add("EventStopBehavior", (Object)this.eventStopBehaviorAsString()).add("FilecacheDuration", (Object)this.filecacheDuration()).add("FragmentLength", (Object)this.fragmentLength()).add("InputLossAction", (Object)this.inputLossActionAsString()).add("NumRetries", (Object)this.numRetries()).add("RestartDelay", (Object)this.restartDelay()).add("SegmentationMode", (Object)this.segmentationModeAsString()).add("SendDelayMs", (Object)this.sendDelayMs()).add("SparseTrackType", (Object)this.sparseTrackTypeAsString()).add("StreamManifestBehavior", (Object)this.streamManifestBehaviorAsString()).add("TimestampOffset", (Object)this.timestampOffset()).add("TimestampOffsetMode", (Object)this.timestampOffsetModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcquisitionPointId": {
                return Optional.of(clazz.cast(this.acquisitionPointId()));
            }
            case "AudioOnlyTimecodeControl": {
                return Optional.of(clazz.cast(this.audioOnlyTimecodeControlAsString()));
            }
            case "CertificateMode": {
                return Optional.of(clazz.cast(this.certificateModeAsString()));
            }
            case "ConnectionRetryInterval": {
                return Optional.of(clazz.cast(this.connectionRetryInterval()));
            }
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
            case "EventId": {
                return Optional.of(clazz.cast(this.eventId()));
            }
            case "EventIdMode": {
                return Optional.of(clazz.cast(this.eventIdModeAsString()));
            }
            case "EventStopBehavior": {
                return Optional.of(clazz.cast(this.eventStopBehaviorAsString()));
            }
            case "FilecacheDuration": {
                return Optional.of(clazz.cast(this.filecacheDuration()));
            }
            case "FragmentLength": {
                return Optional.of(clazz.cast(this.fragmentLength()));
            }
            case "InputLossAction": {
                return Optional.of(clazz.cast(this.inputLossActionAsString()));
            }
            case "NumRetries": {
                return Optional.of(clazz.cast(this.numRetries()));
            }
            case "RestartDelay": {
                return Optional.of(clazz.cast(this.restartDelay()));
            }
            case "SegmentationMode": {
                return Optional.of(clazz.cast(this.segmentationModeAsString()));
            }
            case "SendDelayMs": {
                return Optional.of(clazz.cast(this.sendDelayMs()));
            }
            case "SparseTrackType": {
                return Optional.of(clazz.cast(this.sparseTrackTypeAsString()));
            }
            case "StreamManifestBehavior": {
                return Optional.of(clazz.cast(this.streamManifestBehaviorAsString()));
            }
            case "TimestampOffset": {
                return Optional.of(clazz.cast(this.timestampOffset()));
            }
            case "TimestampOffsetMode": {
                return Optional.of(clazz.cast(this.timestampOffsetModeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MsSmoothGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String acquisitionPointId;
        private String audioOnlyTimecodeControl;
        private String certificateMode;
        private Integer connectionRetryInterval;
        private OutputLocationRef destination;
        private String eventId;
        private String eventIdMode;
        private String eventStopBehavior;
        private Integer filecacheDuration;
        private Integer fragmentLength;
        private String inputLossAction;
        private Integer numRetries;
        private Integer restartDelay;
        private String segmentationMode;
        private Integer sendDelayMs;
        private String sparseTrackType;
        private String streamManifestBehavior;
        private String timestampOffset;
        private String timestampOffsetMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MsSmoothGroupSettings model) {
            this.acquisitionPointId(model.acquisitionPointId);
            this.audioOnlyTimecodeControl(model.audioOnlyTimecodeControl);
            this.certificateMode(model.certificateMode);
            this.connectionRetryInterval(model.connectionRetryInterval);
            this.destination(model.destination);
            this.eventId(model.eventId);
            this.eventIdMode(model.eventIdMode);
            this.eventStopBehavior(model.eventStopBehavior);
            this.filecacheDuration(model.filecacheDuration);
            this.fragmentLength(model.fragmentLength);
            this.inputLossAction(model.inputLossAction);
            this.numRetries(model.numRetries);
            this.restartDelay(model.restartDelay);
            this.segmentationMode(model.segmentationMode);
            this.sendDelayMs(model.sendDelayMs);
            this.sparseTrackType(model.sparseTrackType);
            this.streamManifestBehavior(model.streamManifestBehavior);
            this.timestampOffset(model.timestampOffset);
            this.timestampOffsetMode(model.timestampOffsetMode);
        }

        public final String getAcquisitionPointId() {
            return this.acquisitionPointId;
        }

        @Override
        public final Builder acquisitionPointId(String acquisitionPointId) {
            this.acquisitionPointId = acquisitionPointId;
            return this;
        }

        public final void setAcquisitionPointId(String acquisitionPointId) {
            this.acquisitionPointId = acquisitionPointId;
        }

        public final String getAudioOnlyTimecodeControl() {
            return this.audioOnlyTimecodeControl;
        }

        @Override
        public final Builder audioOnlyTimecodeControl(String audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl = audioOnlyTimecodeControl;
            return this;
        }

        @Override
        public final Builder audioOnlyTimecodeControl(SmoothGroupAudioOnlyTimecodeControl audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl(audioOnlyTimecodeControl.toString());
            return this;
        }

        public final void setAudioOnlyTimecodeControl(String audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl = audioOnlyTimecodeControl;
        }

        public final String getCertificateMode() {
            return this.certificateMode;
        }

        @Override
        public final Builder certificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
            return this;
        }

        @Override
        public final Builder certificateMode(SmoothGroupCertificateMode certificateMode) {
            this.certificateMode(certificateMode.toString());
            return this;
        }

        public final void setCertificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
        }

        public final Integer getConnectionRetryInterval() {
            return this.connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventIdMode() {
            return this.eventIdMode;
        }

        @Override
        public final Builder eventIdMode(String eventIdMode) {
            this.eventIdMode = eventIdMode;
            return this;
        }

        @Override
        public final Builder eventIdMode(SmoothGroupEventIdMode eventIdMode) {
            this.eventIdMode(eventIdMode.toString());
            return this;
        }

        public final void setEventIdMode(String eventIdMode) {
            this.eventIdMode = eventIdMode;
        }

        public final String getEventStopBehavior() {
            return this.eventStopBehavior;
        }

        @Override
        public final Builder eventStopBehavior(String eventStopBehavior) {
            this.eventStopBehavior = eventStopBehavior;
            return this;
        }

        @Override
        public final Builder eventStopBehavior(SmoothGroupEventStopBehavior eventStopBehavior) {
            this.eventStopBehavior(eventStopBehavior.toString());
            return this;
        }

        public final void setEventStopBehavior(String eventStopBehavior) {
            this.eventStopBehavior = eventStopBehavior;
        }

        public final Integer getFilecacheDuration() {
            return this.filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getInputLossAction() {
            return this.inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForMsSmoothOut inputLossAction) {
            this.inputLossAction(inputLossAction.toString());
            return this;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        public final String getSegmentationMode() {
            return this.segmentationMode;
        }

        @Override
        public final Builder segmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
            return this;
        }

        @Override
        public final Builder segmentationMode(SmoothGroupSegmentationMode segmentationMode) {
            this.segmentationMode(segmentationMode.toString());
            return this;
        }

        public final void setSegmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
        }

        public final Integer getSendDelayMs() {
            return this.sendDelayMs;
        }

        @Override
        public final Builder sendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
            return this;
        }

        public final void setSendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
        }

        public final String getSparseTrackType() {
            return this.sparseTrackType;
        }

        @Override
        public final Builder sparseTrackType(String sparseTrackType) {
            this.sparseTrackType = sparseTrackType;
            return this;
        }

        @Override
        public final Builder sparseTrackType(SmoothGroupSparseTrackType sparseTrackType) {
            this.sparseTrackType(sparseTrackType.toString());
            return this;
        }

        public final void setSparseTrackType(String sparseTrackType) {
            this.sparseTrackType = sparseTrackType;
        }

        public final String getStreamManifestBehavior() {
            return this.streamManifestBehavior;
        }

        @Override
        public final Builder streamManifestBehavior(String streamManifestBehavior) {
            this.streamManifestBehavior = streamManifestBehavior;
            return this;
        }

        @Override
        public final Builder streamManifestBehavior(SmoothGroupStreamManifestBehavior streamManifestBehavior) {
            this.streamManifestBehavior(streamManifestBehavior.toString());
            return this;
        }

        public final void setStreamManifestBehavior(String streamManifestBehavior) {
            this.streamManifestBehavior = streamManifestBehavior;
        }

        public final String getTimestampOffset() {
            return this.timestampOffset;
        }

        @Override
        public final Builder timestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
            return this;
        }

        public final void setTimestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
        }

        public final String getTimestampOffsetMode() {
            return this.timestampOffsetMode;
        }

        @Override
        public final Builder timestampOffsetMode(String timestampOffsetMode) {
            this.timestampOffsetMode = timestampOffsetMode;
            return this;
        }

        @Override
        public final Builder timestampOffsetMode(SmoothGroupTimestampOffsetMode timestampOffsetMode) {
            this.timestampOffsetMode(timestampOffsetMode.toString());
            return this;
        }

        public final void setTimestampOffsetMode(String timestampOffsetMode) {
            this.timestampOffsetMode = timestampOffsetMode;
        }

        public MsSmoothGroupSettings build() {
            return new MsSmoothGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MsSmoothGroupSettings> {
        public Builder acquisitionPointId(String var1);

        public Builder audioOnlyTimecodeControl(String var1);

        public Builder audioOnlyTimecodeControl(SmoothGroupAudioOnlyTimecodeControl var1);

        public Builder certificateMode(String var1);

        public Builder certificateMode(SmoothGroupCertificateMode var1);

        public Builder connectionRetryInterval(Integer var1);

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().apply(destination)).build());
        }

        public Builder eventId(String var1);

        public Builder eventIdMode(String var1);

        public Builder eventIdMode(SmoothGroupEventIdMode var1);

        public Builder eventStopBehavior(String var1);

        public Builder eventStopBehavior(SmoothGroupEventStopBehavior var1);

        public Builder filecacheDuration(Integer var1);

        public Builder fragmentLength(Integer var1);

        public Builder inputLossAction(String var1);

        public Builder inputLossAction(InputLossActionForMsSmoothOut var1);

        public Builder numRetries(Integer var1);

        public Builder restartDelay(Integer var1);

        public Builder segmentationMode(String var1);

        public Builder segmentationMode(SmoothGroupSegmentationMode var1);

        public Builder sendDelayMs(Integer var1);

        public Builder sparseTrackType(String var1);

        public Builder sparseTrackType(SmoothGroupSparseTrackType var1);

        public Builder streamManifestBehavior(String var1);

        public Builder streamManifestBehavior(SmoothGroupStreamManifestBehavior var1);

        public Builder timestampOffset(String var1);

        public Builder timestampOffsetMode(String var1);

        public Builder timestampOffsetMode(SmoothGroupTimestampOffsetMode var1);
    }
}

