/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.Mp2CodingMode;
import software.amazon.awssdk.services.medialive.transform.Mp2SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Mp2Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, Mp2Settings> {
    private final Double bitrate;
    private final String codingMode;
    private final Double sampleRate;

    private Mp2Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.codingMode = builder.codingMode;
        this.sampleRate = builder.sampleRate;
    }

    public Double bitrate() {
        return this.bitrate;
    }

    public Mp2CodingMode codingMode() {
        return Mp2CodingMode.fromValue(this.codingMode);
    }

    public String codingModeAsString() {
        return this.codingMode;
    }

    public Double sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp2Settings)) {
            return false;
        }
        Mp2Settings other = (Mp2Settings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public String toString() {
        return ToString.builder((String)"Mp2Settings").add("Bitrate", (Object)this.bitrate()).add("CodingMode", (Object)this.codingModeAsString()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.of(clazz.cast(this.bitrate()));
            }
            case "CodingMode": {
                return Optional.of(clazz.cast(this.codingModeAsString()));
            }
            case "SampleRate": {
                return Optional.of(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Mp2SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bitrate;
        private String codingMode;
        private Double sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp2Settings model) {
            this.bitrate(model.bitrate);
            this.codingMode(model.codingMode);
            this.sampleRate(model.sampleRate);
        }

        public final Double getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Mp2CodingMode codingMode) {
            this.codingMode(codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final Double getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
        }

        public Mp2Settings build() {
            return new Mp2Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Mp2Settings> {
        public Builder bitrate(Double var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Mp2CodingMode var1);

        public Builder sampleRate(Double var1);
    }
}

