/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.DvbNitSettings;
import software.amazon.awssdk.services.medialive.model.DvbSdtSettings;
import software.amazon.awssdk.services.medialive.model.DvbTdtSettings;
import software.amazon.awssdk.services.medialive.model.M2tsAbsentInputAudioBehavior;
import software.amazon.awssdk.services.medialive.model.M2tsArib;
import software.amazon.awssdk.services.medialive.model.M2tsAribCaptionsPidControl;
import software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel;
import software.amazon.awssdk.services.medialive.model.M2tsAudioInterval;
import software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType;
import software.amazon.awssdk.services.medialive.model.M2tsBufferModel;
import software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor;
import software.amazon.awssdk.services.medialive.model.M2tsEbifControl;
import software.amazon.awssdk.services.medialive.model.M2tsEbpPlacement;
import software.amazon.awssdk.services.medialive.model.M2tsEsRateInPes;
import software.amazon.awssdk.services.medialive.model.M2tsKlv;
import software.amazon.awssdk.services.medialive.model.M2tsPcrControl;
import software.amazon.awssdk.services.medialive.model.M2tsRateMode;
import software.amazon.awssdk.services.medialive.model.M2tsScte35Control;
import software.amazon.awssdk.services.medialive.model.M2tsSegmentationMarkers;
import software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle;
import software.amazon.awssdk.services.medialive.model.M2tsTimedMetadataBehavior;
import software.amazon.awssdk.services.medialive.transform.M2tsSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class M2tsSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, M2tsSettings> {
    private final String absentInputAudioBehavior;
    private final String arib;
    private final String aribCaptionsPid;
    private final String aribCaptionsPidControl;
    private final String audioBufferModel;
    private final Integer audioFramesPerPes;
    private final String audioPids;
    private final String audioStreamType;
    private final Integer bitrate;
    private final String bufferModel;
    private final String ccDescriptor;
    private final DvbNitSettings dvbNitSettings;
    private final DvbSdtSettings dvbSdtSettings;
    private final String dvbSubPids;
    private final DvbTdtSettings dvbTdtSettings;
    private final String dvbTeletextPid;
    private final String ebif;
    private final String ebpAudioInterval;
    private final Integer ebpLookaheadMs;
    private final String ebpPlacement;
    private final String ecmPid;
    private final String esRateInPes;
    private final String etvPlatformPid;
    private final String etvSignalPid;
    private final Double fragmentTime;
    private final String klv;
    private final String klvDataPids;
    private final Double nullPacketBitrate;
    private final Integer patInterval;
    private final String pcrControl;
    private final Integer pcrPeriod;
    private final String pcrPid;
    private final Integer pmtInterval;
    private final String pmtPid;
    private final Integer programNum;
    private final String rateMode;
    private final String scte27Pids;
    private final String scte35Control;
    private final String scte35Pid;
    private final String segmentationMarkers;
    private final String segmentationStyle;
    private final Double segmentationTime;
    private final String timedMetadataBehavior;
    private final String timedMetadataPid;
    private final Integer transportStreamId;
    private final String videoPid;

    private M2tsSettings(BuilderImpl builder) {
        this.absentInputAudioBehavior = builder.absentInputAudioBehavior;
        this.arib = builder.arib;
        this.aribCaptionsPid = builder.aribCaptionsPid;
        this.aribCaptionsPidControl = builder.aribCaptionsPidControl;
        this.audioBufferModel = builder.audioBufferModel;
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioPids = builder.audioPids;
        this.audioStreamType = builder.audioStreamType;
        this.bitrate = builder.bitrate;
        this.bufferModel = builder.bufferModel;
        this.ccDescriptor = builder.ccDescriptor;
        this.dvbNitSettings = builder.dvbNitSettings;
        this.dvbSdtSettings = builder.dvbSdtSettings;
        this.dvbSubPids = builder.dvbSubPids;
        this.dvbTdtSettings = builder.dvbTdtSettings;
        this.dvbTeletextPid = builder.dvbTeletextPid;
        this.ebif = builder.ebif;
        this.ebpAudioInterval = builder.ebpAudioInterval;
        this.ebpLookaheadMs = builder.ebpLookaheadMs;
        this.ebpPlacement = builder.ebpPlacement;
        this.ecmPid = builder.ecmPid;
        this.esRateInPes = builder.esRateInPes;
        this.etvPlatformPid = builder.etvPlatformPid;
        this.etvSignalPid = builder.etvSignalPid;
        this.fragmentTime = builder.fragmentTime;
        this.klv = builder.klv;
        this.klvDataPids = builder.klvDataPids;
        this.nullPacketBitrate = builder.nullPacketBitrate;
        this.patInterval = builder.patInterval;
        this.pcrControl = builder.pcrControl;
        this.pcrPeriod = builder.pcrPeriod;
        this.pcrPid = builder.pcrPid;
        this.pmtInterval = builder.pmtInterval;
        this.pmtPid = builder.pmtPid;
        this.programNum = builder.programNum;
        this.rateMode = builder.rateMode;
        this.scte27Pids = builder.scte27Pids;
        this.scte35Control = builder.scte35Control;
        this.scte35Pid = builder.scte35Pid;
        this.segmentationMarkers = builder.segmentationMarkers;
        this.segmentationStyle = builder.segmentationStyle;
        this.segmentationTime = builder.segmentationTime;
        this.timedMetadataBehavior = builder.timedMetadataBehavior;
        this.timedMetadataPid = builder.timedMetadataPid;
        this.transportStreamId = builder.transportStreamId;
        this.videoPid = builder.videoPid;
    }

    public M2tsAbsentInputAudioBehavior absentInputAudioBehavior() {
        return M2tsAbsentInputAudioBehavior.fromValue(this.absentInputAudioBehavior);
    }

    public String absentInputAudioBehaviorAsString() {
        return this.absentInputAudioBehavior;
    }

    public M2tsArib arib() {
        return M2tsArib.fromValue(this.arib);
    }

    public String aribAsString() {
        return this.arib;
    }

    public String aribCaptionsPid() {
        return this.aribCaptionsPid;
    }

    public M2tsAribCaptionsPidControl aribCaptionsPidControl() {
        return M2tsAribCaptionsPidControl.fromValue(this.aribCaptionsPidControl);
    }

    public String aribCaptionsPidControlAsString() {
        return this.aribCaptionsPidControl;
    }

    public M2tsAudioBufferModel audioBufferModel() {
        return M2tsAudioBufferModel.fromValue(this.audioBufferModel);
    }

    public String audioBufferModelAsString() {
        return this.audioBufferModel;
    }

    public Integer audioFramesPerPes() {
        return this.audioFramesPerPes;
    }

    public String audioPids() {
        return this.audioPids;
    }

    public M2tsAudioStreamType audioStreamType() {
        return M2tsAudioStreamType.fromValue(this.audioStreamType);
    }

    public String audioStreamTypeAsString() {
        return this.audioStreamType;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public M2tsBufferModel bufferModel() {
        return M2tsBufferModel.fromValue(this.bufferModel);
    }

    public String bufferModelAsString() {
        return this.bufferModel;
    }

    public M2tsCcDescriptor ccDescriptor() {
        return M2tsCcDescriptor.fromValue(this.ccDescriptor);
    }

    public String ccDescriptorAsString() {
        return this.ccDescriptor;
    }

    public DvbNitSettings dvbNitSettings() {
        return this.dvbNitSettings;
    }

    public DvbSdtSettings dvbSdtSettings() {
        return this.dvbSdtSettings;
    }

    public String dvbSubPids() {
        return this.dvbSubPids;
    }

    public DvbTdtSettings dvbTdtSettings() {
        return this.dvbTdtSettings;
    }

    public String dvbTeletextPid() {
        return this.dvbTeletextPid;
    }

    public M2tsEbifControl ebif() {
        return M2tsEbifControl.fromValue(this.ebif);
    }

    public String ebifAsString() {
        return this.ebif;
    }

    public M2tsAudioInterval ebpAudioInterval() {
        return M2tsAudioInterval.fromValue(this.ebpAudioInterval);
    }

    public String ebpAudioIntervalAsString() {
        return this.ebpAudioInterval;
    }

    public Integer ebpLookaheadMs() {
        return this.ebpLookaheadMs;
    }

    public M2tsEbpPlacement ebpPlacement() {
        return M2tsEbpPlacement.fromValue(this.ebpPlacement);
    }

    public String ebpPlacementAsString() {
        return this.ebpPlacement;
    }

    public String ecmPid() {
        return this.ecmPid;
    }

    public M2tsEsRateInPes esRateInPes() {
        return M2tsEsRateInPes.fromValue(this.esRateInPes);
    }

    public String esRateInPesAsString() {
        return this.esRateInPes;
    }

    public String etvPlatformPid() {
        return this.etvPlatformPid;
    }

    public String etvSignalPid() {
        return this.etvSignalPid;
    }

    public Double fragmentTime() {
        return this.fragmentTime;
    }

    public M2tsKlv klv() {
        return M2tsKlv.fromValue(this.klv);
    }

    public String klvAsString() {
        return this.klv;
    }

    public String klvDataPids() {
        return this.klvDataPids;
    }

    public Double nullPacketBitrate() {
        return this.nullPacketBitrate;
    }

    public Integer patInterval() {
        return this.patInterval;
    }

    public M2tsPcrControl pcrControl() {
        return M2tsPcrControl.fromValue(this.pcrControl);
    }

    public String pcrControlAsString() {
        return this.pcrControl;
    }

    public Integer pcrPeriod() {
        return this.pcrPeriod;
    }

    public String pcrPid() {
        return this.pcrPid;
    }

    public Integer pmtInterval() {
        return this.pmtInterval;
    }

    public String pmtPid() {
        return this.pmtPid;
    }

    public Integer programNum() {
        return this.programNum;
    }

    public M2tsRateMode rateMode() {
        return M2tsRateMode.fromValue(this.rateMode);
    }

    public String rateModeAsString() {
        return this.rateMode;
    }

    public String scte27Pids() {
        return this.scte27Pids;
    }

    public M2tsScte35Control scte35Control() {
        return M2tsScte35Control.fromValue(this.scte35Control);
    }

    public String scte35ControlAsString() {
        return this.scte35Control;
    }

    public String scte35Pid() {
        return this.scte35Pid;
    }

    public M2tsSegmentationMarkers segmentationMarkers() {
        return M2tsSegmentationMarkers.fromValue(this.segmentationMarkers);
    }

    public String segmentationMarkersAsString() {
        return this.segmentationMarkers;
    }

    public M2tsSegmentationStyle segmentationStyle() {
        return M2tsSegmentationStyle.fromValue(this.segmentationStyle);
    }

    public String segmentationStyleAsString() {
        return this.segmentationStyle;
    }

    public Double segmentationTime() {
        return this.segmentationTime;
    }

    public M2tsTimedMetadataBehavior timedMetadataBehavior() {
        return M2tsTimedMetadataBehavior.fromValue(this.timedMetadataBehavior);
    }

    public String timedMetadataBehaviorAsString() {
        return this.timedMetadataBehavior;
    }

    public String timedMetadataPid() {
        return this.timedMetadataPid;
    }

    public Integer transportStreamId() {
        return this.transportStreamId;
    }

    public String videoPid() {
        return this.videoPid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.absentInputAudioBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aribAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aribCaptionsPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.aribCaptionsPidControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioBufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioPids());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ccDescriptorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbNitSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSdtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSubPids());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbTdtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbTeletextPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebifAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebpAudioIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebpLookaheadMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebpPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecmPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.esRateInPesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.etvPlatformPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.etvSignalPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.klvAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.klvDataPids());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullPacketBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.patInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNum());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte27Pids());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35ControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoPid());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2tsSettings)) {
            return false;
        }
        M2tsSettings other = (M2tsSettings)obj;
        return Objects.equals(this.absentInputAudioBehaviorAsString(), other.absentInputAudioBehaviorAsString()) && Objects.equals(this.aribAsString(), other.aribAsString()) && Objects.equals(this.aribCaptionsPid(), other.aribCaptionsPid()) && Objects.equals(this.aribCaptionsPidControlAsString(), other.aribCaptionsPidControlAsString()) && Objects.equals(this.audioBufferModelAsString(), other.audioBufferModelAsString()) && Objects.equals(this.audioFramesPerPes(), other.audioFramesPerPes()) && Objects.equals(this.audioPids(), other.audioPids()) && Objects.equals(this.audioStreamTypeAsString(), other.audioStreamTypeAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bufferModelAsString(), other.bufferModelAsString()) && Objects.equals(this.ccDescriptorAsString(), other.ccDescriptorAsString()) && Objects.equals(this.dvbNitSettings(), other.dvbNitSettings()) && Objects.equals(this.dvbSdtSettings(), other.dvbSdtSettings()) && Objects.equals(this.dvbSubPids(), other.dvbSubPids()) && Objects.equals(this.dvbTdtSettings(), other.dvbTdtSettings()) && Objects.equals(this.dvbTeletextPid(), other.dvbTeletextPid()) && Objects.equals(this.ebifAsString(), other.ebifAsString()) && Objects.equals(this.ebpAudioIntervalAsString(), other.ebpAudioIntervalAsString()) && Objects.equals(this.ebpLookaheadMs(), other.ebpLookaheadMs()) && Objects.equals(this.ebpPlacementAsString(), other.ebpPlacementAsString()) && Objects.equals(this.ecmPid(), other.ecmPid()) && Objects.equals(this.esRateInPesAsString(), other.esRateInPesAsString()) && Objects.equals(this.etvPlatformPid(), other.etvPlatformPid()) && Objects.equals(this.etvSignalPid(), other.etvSignalPid()) && Objects.equals(this.fragmentTime(), other.fragmentTime()) && Objects.equals(this.klvAsString(), other.klvAsString()) && Objects.equals(this.klvDataPids(), other.klvDataPids()) && Objects.equals(this.nullPacketBitrate(), other.nullPacketBitrate()) && Objects.equals(this.patInterval(), other.patInterval()) && Objects.equals(this.pcrControlAsString(), other.pcrControlAsString()) && Objects.equals(this.pcrPeriod(), other.pcrPeriod()) && Objects.equals(this.pcrPid(), other.pcrPid()) && Objects.equals(this.pmtInterval(), other.pmtInterval()) && Objects.equals(this.pmtPid(), other.pmtPid()) && Objects.equals(this.programNum(), other.programNum()) && Objects.equals(this.rateModeAsString(), other.rateModeAsString()) && Objects.equals(this.scte27Pids(), other.scte27Pids()) && Objects.equals(this.scte35ControlAsString(), other.scte35ControlAsString()) && Objects.equals(this.scte35Pid(), other.scte35Pid()) && Objects.equals(this.segmentationMarkersAsString(), other.segmentationMarkersAsString()) && Objects.equals(this.segmentationStyleAsString(), other.segmentationStyleAsString()) && Objects.equals(this.segmentationTime(), other.segmentationTime()) && Objects.equals(this.timedMetadataBehaviorAsString(), other.timedMetadataBehaviorAsString()) && Objects.equals(this.timedMetadataPid(), other.timedMetadataPid()) && Objects.equals(this.transportStreamId(), other.transportStreamId()) && Objects.equals(this.videoPid(), other.videoPid());
    }

    public String toString() {
        return ToString.builder((String)"M2tsSettings").add("AbsentInputAudioBehavior", (Object)this.absentInputAudioBehaviorAsString()).add("Arib", (Object)this.aribAsString()).add("AribCaptionsPid", (Object)this.aribCaptionsPid()).add("AribCaptionsPidControl", (Object)this.aribCaptionsPidControlAsString()).add("AudioBufferModel", (Object)this.audioBufferModelAsString()).add("AudioFramesPerPes", (Object)this.audioFramesPerPes()).add("AudioPids", (Object)this.audioPids()).add("AudioStreamType", (Object)this.audioStreamTypeAsString()).add("Bitrate", (Object)this.bitrate()).add("BufferModel", (Object)this.bufferModelAsString()).add("CcDescriptor", (Object)this.ccDescriptorAsString()).add("DvbNitSettings", (Object)this.dvbNitSettings()).add("DvbSdtSettings", (Object)this.dvbSdtSettings()).add("DvbSubPids", (Object)this.dvbSubPids()).add("DvbTdtSettings", (Object)this.dvbTdtSettings()).add("DvbTeletextPid", (Object)this.dvbTeletextPid()).add("Ebif", (Object)this.ebifAsString()).add("EbpAudioInterval", (Object)this.ebpAudioIntervalAsString()).add("EbpLookaheadMs", (Object)this.ebpLookaheadMs()).add("EbpPlacement", (Object)this.ebpPlacementAsString()).add("EcmPid", (Object)this.ecmPid()).add("EsRateInPes", (Object)this.esRateInPesAsString()).add("EtvPlatformPid", (Object)this.etvPlatformPid()).add("EtvSignalPid", (Object)this.etvSignalPid()).add("FragmentTime", (Object)this.fragmentTime()).add("Klv", (Object)this.klvAsString()).add("KlvDataPids", (Object)this.klvDataPids()).add("NullPacketBitrate", (Object)this.nullPacketBitrate()).add("PatInterval", (Object)this.patInterval()).add("PcrControl", (Object)this.pcrControlAsString()).add("PcrPeriod", (Object)this.pcrPeriod()).add("PcrPid", (Object)this.pcrPid()).add("PmtInterval", (Object)this.pmtInterval()).add("PmtPid", (Object)this.pmtPid()).add("ProgramNum", (Object)this.programNum()).add("RateMode", (Object)this.rateModeAsString()).add("Scte27Pids", (Object)this.scte27Pids()).add("Scte35Control", (Object)this.scte35ControlAsString()).add("Scte35Pid", (Object)this.scte35Pid()).add("SegmentationMarkers", (Object)this.segmentationMarkersAsString()).add("SegmentationStyle", (Object)this.segmentationStyleAsString()).add("SegmentationTime", (Object)this.segmentationTime()).add("TimedMetadataBehavior", (Object)this.timedMetadataBehaviorAsString()).add("TimedMetadataPid", (Object)this.timedMetadataPid()).add("TransportStreamId", (Object)this.transportStreamId()).add("VideoPid", (Object)this.videoPid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AbsentInputAudioBehavior": {
                return Optional.of(clazz.cast(this.absentInputAudioBehaviorAsString()));
            }
            case "Arib": {
                return Optional.of(clazz.cast(this.aribAsString()));
            }
            case "AribCaptionsPid": {
                return Optional.of(clazz.cast(this.aribCaptionsPid()));
            }
            case "AribCaptionsPidControl": {
                return Optional.of(clazz.cast(this.aribCaptionsPidControlAsString()));
            }
            case "AudioBufferModel": {
                return Optional.of(clazz.cast(this.audioBufferModelAsString()));
            }
            case "AudioFramesPerPes": {
                return Optional.of(clazz.cast(this.audioFramesPerPes()));
            }
            case "AudioPids": {
                return Optional.of(clazz.cast(this.audioPids()));
            }
            case "AudioStreamType": {
                return Optional.of(clazz.cast(this.audioStreamTypeAsString()));
            }
            case "Bitrate": {
                return Optional.of(clazz.cast(this.bitrate()));
            }
            case "BufferModel": {
                return Optional.of(clazz.cast(this.bufferModelAsString()));
            }
            case "CcDescriptor": {
                return Optional.of(clazz.cast(this.ccDescriptorAsString()));
            }
            case "DvbNitSettings": {
                return Optional.of(clazz.cast(this.dvbNitSettings()));
            }
            case "DvbSdtSettings": {
                return Optional.of(clazz.cast(this.dvbSdtSettings()));
            }
            case "DvbSubPids": {
                return Optional.of(clazz.cast(this.dvbSubPids()));
            }
            case "DvbTdtSettings": {
                return Optional.of(clazz.cast(this.dvbTdtSettings()));
            }
            case "DvbTeletextPid": {
                return Optional.of(clazz.cast(this.dvbTeletextPid()));
            }
            case "Ebif": {
                return Optional.of(clazz.cast(this.ebifAsString()));
            }
            case "EbpAudioInterval": {
                return Optional.of(clazz.cast(this.ebpAudioIntervalAsString()));
            }
            case "EbpLookaheadMs": {
                return Optional.of(clazz.cast(this.ebpLookaheadMs()));
            }
            case "EbpPlacement": {
                return Optional.of(clazz.cast(this.ebpPlacementAsString()));
            }
            case "EcmPid": {
                return Optional.of(clazz.cast(this.ecmPid()));
            }
            case "EsRateInPes": {
                return Optional.of(clazz.cast(this.esRateInPesAsString()));
            }
            case "EtvPlatformPid": {
                return Optional.of(clazz.cast(this.etvPlatformPid()));
            }
            case "EtvSignalPid": {
                return Optional.of(clazz.cast(this.etvSignalPid()));
            }
            case "FragmentTime": {
                return Optional.of(clazz.cast(this.fragmentTime()));
            }
            case "Klv": {
                return Optional.of(clazz.cast(this.klvAsString()));
            }
            case "KlvDataPids": {
                return Optional.of(clazz.cast(this.klvDataPids()));
            }
            case "NullPacketBitrate": {
                return Optional.of(clazz.cast(this.nullPacketBitrate()));
            }
            case "PatInterval": {
                return Optional.of(clazz.cast(this.patInterval()));
            }
            case "PcrControl": {
                return Optional.of(clazz.cast(this.pcrControlAsString()));
            }
            case "PcrPeriod": {
                return Optional.of(clazz.cast(this.pcrPeriod()));
            }
            case "PcrPid": {
                return Optional.of(clazz.cast(this.pcrPid()));
            }
            case "PmtInterval": {
                return Optional.of(clazz.cast(this.pmtInterval()));
            }
            case "PmtPid": {
                return Optional.of(clazz.cast(this.pmtPid()));
            }
            case "ProgramNum": {
                return Optional.of(clazz.cast(this.programNum()));
            }
            case "RateMode": {
                return Optional.of(clazz.cast(this.rateModeAsString()));
            }
            case "Scte27Pids": {
                return Optional.of(clazz.cast(this.scte27Pids()));
            }
            case "Scte35Control": {
                return Optional.of(clazz.cast(this.scte35ControlAsString()));
            }
            case "Scte35Pid": {
                return Optional.of(clazz.cast(this.scte35Pid()));
            }
            case "SegmentationMarkers": {
                return Optional.of(clazz.cast(this.segmentationMarkersAsString()));
            }
            case "SegmentationStyle": {
                return Optional.of(clazz.cast(this.segmentationStyleAsString()));
            }
            case "SegmentationTime": {
                return Optional.of(clazz.cast(this.segmentationTime()));
            }
            case "TimedMetadataBehavior": {
                return Optional.of(clazz.cast(this.timedMetadataBehaviorAsString()));
            }
            case "TimedMetadataPid": {
                return Optional.of(clazz.cast(this.timedMetadataPid()));
            }
            case "TransportStreamId": {
                return Optional.of(clazz.cast(this.transportStreamId()));
            }
            case "VideoPid": {
                return Optional.of(clazz.cast(this.videoPid()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        M2tsSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String absentInputAudioBehavior;
        private String arib;
        private String aribCaptionsPid;
        private String aribCaptionsPidControl;
        private String audioBufferModel;
        private Integer audioFramesPerPes;
        private String audioPids;
        private String audioStreamType;
        private Integer bitrate;
        private String bufferModel;
        private String ccDescriptor;
        private DvbNitSettings dvbNitSettings;
        private DvbSdtSettings dvbSdtSettings;
        private String dvbSubPids;
        private DvbTdtSettings dvbTdtSettings;
        private String dvbTeletextPid;
        private String ebif;
        private String ebpAudioInterval;
        private Integer ebpLookaheadMs;
        private String ebpPlacement;
        private String ecmPid;
        private String esRateInPes;
        private String etvPlatformPid;
        private String etvSignalPid;
        private Double fragmentTime;
        private String klv;
        private String klvDataPids;
        private Double nullPacketBitrate;
        private Integer patInterval;
        private String pcrControl;
        private Integer pcrPeriod;
        private String pcrPid;
        private Integer pmtInterval;
        private String pmtPid;
        private Integer programNum;
        private String rateMode;
        private String scte27Pids;
        private String scte35Control;
        private String scte35Pid;
        private String segmentationMarkers;
        private String segmentationStyle;
        private Double segmentationTime;
        private String timedMetadataBehavior;
        private String timedMetadataPid;
        private Integer transportStreamId;
        private String videoPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M2tsSettings model) {
            this.absentInputAudioBehavior(model.absentInputAudioBehavior);
            this.arib(model.arib);
            this.aribCaptionsPid(model.aribCaptionsPid);
            this.aribCaptionsPidControl(model.aribCaptionsPidControl);
            this.audioBufferModel(model.audioBufferModel);
            this.audioFramesPerPes(model.audioFramesPerPes);
            this.audioPids(model.audioPids);
            this.audioStreamType(model.audioStreamType);
            this.bitrate(model.bitrate);
            this.bufferModel(model.bufferModel);
            this.ccDescriptor(model.ccDescriptor);
            this.dvbNitSettings(model.dvbNitSettings);
            this.dvbSdtSettings(model.dvbSdtSettings);
            this.dvbSubPids(model.dvbSubPids);
            this.dvbTdtSettings(model.dvbTdtSettings);
            this.dvbTeletextPid(model.dvbTeletextPid);
            this.ebif(model.ebif);
            this.ebpAudioInterval(model.ebpAudioInterval);
            this.ebpLookaheadMs(model.ebpLookaheadMs);
            this.ebpPlacement(model.ebpPlacement);
            this.ecmPid(model.ecmPid);
            this.esRateInPes(model.esRateInPes);
            this.etvPlatformPid(model.etvPlatformPid);
            this.etvSignalPid(model.etvSignalPid);
            this.fragmentTime(model.fragmentTime);
            this.klv(model.klv);
            this.klvDataPids(model.klvDataPids);
            this.nullPacketBitrate(model.nullPacketBitrate);
            this.patInterval(model.patInterval);
            this.pcrControl(model.pcrControl);
            this.pcrPeriod(model.pcrPeriod);
            this.pcrPid(model.pcrPid);
            this.pmtInterval(model.pmtInterval);
            this.pmtPid(model.pmtPid);
            this.programNum(model.programNum);
            this.rateMode(model.rateMode);
            this.scte27Pids(model.scte27Pids);
            this.scte35Control(model.scte35Control);
            this.scte35Pid(model.scte35Pid);
            this.segmentationMarkers(model.segmentationMarkers);
            this.segmentationStyle(model.segmentationStyle);
            this.segmentationTime(model.segmentationTime);
            this.timedMetadataBehavior(model.timedMetadataBehavior);
            this.timedMetadataPid(model.timedMetadataPid);
            this.transportStreamId(model.transportStreamId);
            this.videoPid(model.videoPid);
        }

        public final String getAbsentInputAudioBehavior() {
            return this.absentInputAudioBehavior;
        }

        @Override
        public final Builder absentInputAudioBehavior(String absentInputAudioBehavior) {
            this.absentInputAudioBehavior = absentInputAudioBehavior;
            return this;
        }

        @Override
        public final Builder absentInputAudioBehavior(M2tsAbsentInputAudioBehavior absentInputAudioBehavior) {
            this.absentInputAudioBehavior(absentInputAudioBehavior.toString());
            return this;
        }

        public final void setAbsentInputAudioBehavior(String absentInputAudioBehavior) {
            this.absentInputAudioBehavior = absentInputAudioBehavior;
        }

        public final String getArib() {
            return this.arib;
        }

        @Override
        public final Builder arib(String arib) {
            this.arib = arib;
            return this;
        }

        @Override
        public final Builder arib(M2tsArib arib) {
            this.arib(arib.toString());
            return this;
        }

        public final void setArib(String arib) {
            this.arib = arib;
        }

        public final String getAribCaptionsPid() {
            return this.aribCaptionsPid;
        }

        @Override
        public final Builder aribCaptionsPid(String aribCaptionsPid) {
            this.aribCaptionsPid = aribCaptionsPid;
            return this;
        }

        public final void setAribCaptionsPid(String aribCaptionsPid) {
            this.aribCaptionsPid = aribCaptionsPid;
        }

        public final String getAribCaptionsPidControl() {
            return this.aribCaptionsPidControl;
        }

        @Override
        public final Builder aribCaptionsPidControl(String aribCaptionsPidControl) {
            this.aribCaptionsPidControl = aribCaptionsPidControl;
            return this;
        }

        @Override
        public final Builder aribCaptionsPidControl(M2tsAribCaptionsPidControl aribCaptionsPidControl) {
            this.aribCaptionsPidControl(aribCaptionsPidControl.toString());
            return this;
        }

        public final void setAribCaptionsPidControl(String aribCaptionsPidControl) {
            this.aribCaptionsPidControl = aribCaptionsPidControl;
        }

        public final String getAudioBufferModel() {
            return this.audioBufferModel;
        }

        @Override
        public final Builder audioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
            return this;
        }

        @Override
        public final Builder audioBufferModel(M2tsAudioBufferModel audioBufferModel) {
            this.audioBufferModel(audioBufferModel.toString());
            return this;
        }

        public final void setAudioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
        }

        public final Integer getAudioFramesPerPes() {
            return this.audioFramesPerPes;
        }

        @Override
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        public final String getAudioPids() {
            return this.audioPids;
        }

        @Override
        public final Builder audioPids(String audioPids) {
            this.audioPids = audioPids;
            return this;
        }

        public final void setAudioPids(String audioPids) {
            this.audioPids = audioPids;
        }

        public final String getAudioStreamType() {
            return this.audioStreamType;
        }

        @Override
        public final Builder audioStreamType(String audioStreamType) {
            this.audioStreamType = audioStreamType;
            return this;
        }

        @Override
        public final Builder audioStreamType(M2tsAudioStreamType audioStreamType) {
            this.audioStreamType(audioStreamType.toString());
            return this;
        }

        public final void setAudioStreamType(String audioStreamType) {
            this.audioStreamType = audioStreamType;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getBufferModel() {
            return this.bufferModel;
        }

        @Override
        public final Builder bufferModel(String bufferModel) {
            this.bufferModel = bufferModel;
            return this;
        }

        @Override
        public final Builder bufferModel(M2tsBufferModel bufferModel) {
            this.bufferModel(bufferModel.toString());
            return this;
        }

        public final void setBufferModel(String bufferModel) {
            this.bufferModel = bufferModel;
        }

        public final String getCcDescriptor() {
            return this.ccDescriptor;
        }

        @Override
        public final Builder ccDescriptor(String ccDescriptor) {
            this.ccDescriptor = ccDescriptor;
            return this;
        }

        @Override
        public final Builder ccDescriptor(M2tsCcDescriptor ccDescriptor) {
            this.ccDescriptor(ccDescriptor.toString());
            return this;
        }

        public final void setCcDescriptor(String ccDescriptor) {
            this.ccDescriptor = ccDescriptor;
        }

        public final DvbNitSettings.Builder getDvbNitSettings() {
            return this.dvbNitSettings != null ? this.dvbNitSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbNitSettings(DvbNitSettings dvbNitSettings) {
            this.dvbNitSettings = dvbNitSettings;
            return this;
        }

        public final void setDvbNitSettings(DvbNitSettings.BuilderImpl dvbNitSettings) {
            this.dvbNitSettings = dvbNitSettings != null ? dvbNitSettings.build() : null;
        }

        public final DvbSdtSettings.Builder getDvbSdtSettings() {
            return this.dvbSdtSettings != null ? this.dvbSdtSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSdtSettings(DvbSdtSettings dvbSdtSettings) {
            this.dvbSdtSettings = dvbSdtSettings;
            return this;
        }

        public final void setDvbSdtSettings(DvbSdtSettings.BuilderImpl dvbSdtSettings) {
            this.dvbSdtSettings = dvbSdtSettings != null ? dvbSdtSettings.build() : null;
        }

        public final String getDvbSubPids() {
            return this.dvbSubPids;
        }

        @Override
        public final Builder dvbSubPids(String dvbSubPids) {
            this.dvbSubPids = dvbSubPids;
            return this;
        }

        public final void setDvbSubPids(String dvbSubPids) {
            this.dvbSubPids = dvbSubPids;
        }

        public final DvbTdtSettings.Builder getDvbTdtSettings() {
            return this.dvbTdtSettings != null ? this.dvbTdtSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbTdtSettings(DvbTdtSettings dvbTdtSettings) {
            this.dvbTdtSettings = dvbTdtSettings;
            return this;
        }

        public final void setDvbTdtSettings(DvbTdtSettings.BuilderImpl dvbTdtSettings) {
            this.dvbTdtSettings = dvbTdtSettings != null ? dvbTdtSettings.build() : null;
        }

        public final String getDvbTeletextPid() {
            return this.dvbTeletextPid;
        }

        @Override
        public final Builder dvbTeletextPid(String dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
            return this;
        }

        public final void setDvbTeletextPid(String dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
        }

        public final String getEbif() {
            return this.ebif;
        }

        @Override
        public final Builder ebif(String ebif) {
            this.ebif = ebif;
            return this;
        }

        @Override
        public final Builder ebif(M2tsEbifControl ebif) {
            this.ebif(ebif.toString());
            return this;
        }

        public final void setEbif(String ebif) {
            this.ebif = ebif;
        }

        public final String getEbpAudioInterval() {
            return this.ebpAudioInterval;
        }

        @Override
        public final Builder ebpAudioInterval(String ebpAudioInterval) {
            this.ebpAudioInterval = ebpAudioInterval;
            return this;
        }

        @Override
        public final Builder ebpAudioInterval(M2tsAudioInterval ebpAudioInterval) {
            this.ebpAudioInterval(ebpAudioInterval.toString());
            return this;
        }

        public final void setEbpAudioInterval(String ebpAudioInterval) {
            this.ebpAudioInterval = ebpAudioInterval;
        }

        public final Integer getEbpLookaheadMs() {
            return this.ebpLookaheadMs;
        }

        @Override
        public final Builder ebpLookaheadMs(Integer ebpLookaheadMs) {
            this.ebpLookaheadMs = ebpLookaheadMs;
            return this;
        }

        public final void setEbpLookaheadMs(Integer ebpLookaheadMs) {
            this.ebpLookaheadMs = ebpLookaheadMs;
        }

        public final String getEbpPlacement() {
            return this.ebpPlacement;
        }

        @Override
        public final Builder ebpPlacement(String ebpPlacement) {
            this.ebpPlacement = ebpPlacement;
            return this;
        }

        @Override
        public final Builder ebpPlacement(M2tsEbpPlacement ebpPlacement) {
            this.ebpPlacement(ebpPlacement.toString());
            return this;
        }

        public final void setEbpPlacement(String ebpPlacement) {
            this.ebpPlacement = ebpPlacement;
        }

        public final String getEcmPid() {
            return this.ecmPid;
        }

        @Override
        public final Builder ecmPid(String ecmPid) {
            this.ecmPid = ecmPid;
            return this;
        }

        public final void setEcmPid(String ecmPid) {
            this.ecmPid = ecmPid;
        }

        public final String getEsRateInPes() {
            return this.esRateInPes;
        }

        @Override
        public final Builder esRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
            return this;
        }

        @Override
        public final Builder esRateInPes(M2tsEsRateInPes esRateInPes) {
            this.esRateInPes(esRateInPes.toString());
            return this;
        }

        public final void setEsRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
        }

        public final String getEtvPlatformPid() {
            return this.etvPlatformPid;
        }

        @Override
        public final Builder etvPlatformPid(String etvPlatformPid) {
            this.etvPlatformPid = etvPlatformPid;
            return this;
        }

        public final void setEtvPlatformPid(String etvPlatformPid) {
            this.etvPlatformPid = etvPlatformPid;
        }

        public final String getEtvSignalPid() {
            return this.etvSignalPid;
        }

        @Override
        public final Builder etvSignalPid(String etvSignalPid) {
            this.etvSignalPid = etvSignalPid;
            return this;
        }

        public final void setEtvSignalPid(String etvSignalPid) {
            this.etvSignalPid = etvSignalPid;
        }

        public final Double getFragmentTime() {
            return this.fragmentTime;
        }

        @Override
        public final Builder fragmentTime(Double fragmentTime) {
            this.fragmentTime = fragmentTime;
            return this;
        }

        public final void setFragmentTime(Double fragmentTime) {
            this.fragmentTime = fragmentTime;
        }

        public final String getKlv() {
            return this.klv;
        }

        @Override
        public final Builder klv(String klv) {
            this.klv = klv;
            return this;
        }

        @Override
        public final Builder klv(M2tsKlv klv) {
            this.klv(klv.toString());
            return this;
        }

        public final void setKlv(String klv) {
            this.klv = klv;
        }

        public final String getKlvDataPids() {
            return this.klvDataPids;
        }

        @Override
        public final Builder klvDataPids(String klvDataPids) {
            this.klvDataPids = klvDataPids;
            return this;
        }

        public final void setKlvDataPids(String klvDataPids) {
            this.klvDataPids = klvDataPids;
        }

        public final Double getNullPacketBitrate() {
            return this.nullPacketBitrate;
        }

        @Override
        public final Builder nullPacketBitrate(Double nullPacketBitrate) {
            this.nullPacketBitrate = nullPacketBitrate;
            return this;
        }

        public final void setNullPacketBitrate(Double nullPacketBitrate) {
            this.nullPacketBitrate = nullPacketBitrate;
        }

        public final Integer getPatInterval() {
            return this.patInterval;
        }

        @Override
        public final Builder patInterval(Integer patInterval) {
            this.patInterval = patInterval;
            return this;
        }

        public final void setPatInterval(Integer patInterval) {
            this.patInterval = patInterval;
        }

        public final String getPcrControl() {
            return this.pcrControl;
        }

        @Override
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        public final Builder pcrControl(M2tsPcrControl pcrControl) {
            this.pcrControl(pcrControl.toString());
            return this;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        public final Integer getPcrPeriod() {
            return this.pcrPeriod;
        }

        @Override
        public final Builder pcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
            return this;
        }

        public final void setPcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
        }

        public final String getPcrPid() {
            return this.pcrPid;
        }

        @Override
        public final Builder pcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final void setPcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
        }

        public final Integer getPmtInterval() {
            return this.pmtInterval;
        }

        @Override
        public final Builder pmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
            return this;
        }

        public final void setPmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
        }

        public final String getPmtPid() {
            return this.pmtPid;
        }

        @Override
        public final Builder pmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final void setPmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
        }

        public final Integer getProgramNum() {
            return this.programNum;
        }

        @Override
        public final Builder programNum(Integer programNum) {
            this.programNum = programNum;
            return this;
        }

        public final void setProgramNum(Integer programNum) {
            this.programNum = programNum;
        }

        public final String getRateMode() {
            return this.rateMode;
        }

        @Override
        public final Builder rateMode(String rateMode) {
            this.rateMode = rateMode;
            return this;
        }

        @Override
        public final Builder rateMode(M2tsRateMode rateMode) {
            this.rateMode(rateMode.toString());
            return this;
        }

        public final void setRateMode(String rateMode) {
            this.rateMode = rateMode;
        }

        public final String getScte27Pids() {
            return this.scte27Pids;
        }

        @Override
        public final Builder scte27Pids(String scte27Pids) {
            this.scte27Pids = scte27Pids;
            return this;
        }

        public final void setScte27Pids(String scte27Pids) {
            this.scte27Pids = scte27Pids;
        }

        public final String getScte35Control() {
            return this.scte35Control;
        }

        @Override
        public final Builder scte35Control(String scte35Control) {
            this.scte35Control = scte35Control;
            return this;
        }

        @Override
        public final Builder scte35Control(M2tsScte35Control scte35Control) {
            this.scte35Control(scte35Control.toString());
            return this;
        }

        public final void setScte35Control(String scte35Control) {
            this.scte35Control = scte35Control;
        }

        public final String getScte35Pid() {
            return this.scte35Pid;
        }

        @Override
        public final Builder scte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final void setScte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        public final String getSegmentationMarkers() {
            return this.segmentationMarkers;
        }

        @Override
        public final Builder segmentationMarkers(String segmentationMarkers) {
            this.segmentationMarkers = segmentationMarkers;
            return this;
        }

        @Override
        public final Builder segmentationMarkers(M2tsSegmentationMarkers segmentationMarkers) {
            this.segmentationMarkers(segmentationMarkers.toString());
            return this;
        }

        public final void setSegmentationMarkers(String segmentationMarkers) {
            this.segmentationMarkers = segmentationMarkers;
        }

        public final String getSegmentationStyle() {
            return this.segmentationStyle;
        }

        @Override
        public final Builder segmentationStyle(String segmentationStyle) {
            this.segmentationStyle = segmentationStyle;
            return this;
        }

        @Override
        public final Builder segmentationStyle(M2tsSegmentationStyle segmentationStyle) {
            this.segmentationStyle(segmentationStyle.toString());
            return this;
        }

        public final void setSegmentationStyle(String segmentationStyle) {
            this.segmentationStyle = segmentationStyle;
        }

        public final Double getSegmentationTime() {
            return this.segmentationTime;
        }

        @Override
        public final Builder segmentationTime(Double segmentationTime) {
            this.segmentationTime = segmentationTime;
            return this;
        }

        public final void setSegmentationTime(Double segmentationTime) {
            this.segmentationTime = segmentationTime;
        }

        public final String getTimedMetadataBehavior() {
            return this.timedMetadataBehavior;
        }

        @Override
        public final Builder timedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
            return this;
        }

        @Override
        public final Builder timedMetadataBehavior(M2tsTimedMetadataBehavior timedMetadataBehavior) {
            this.timedMetadataBehavior(timedMetadataBehavior.toString());
            return this;
        }

        public final void setTimedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
        }

        public final String getTimedMetadataPid() {
            return this.timedMetadataPid;
        }

        @Override
        public final Builder timedMetadataPid(String timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
            return this;
        }

        public final void setTimedMetadataPid(String timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
        }

        public final Integer getTransportStreamId() {
            return this.transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final String getVideoPid() {
            return this.videoPid;
        }

        @Override
        public final Builder videoPid(String videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        public final void setVideoPid(String videoPid) {
            this.videoPid = videoPid;
        }

        public M2tsSettings build() {
            return new M2tsSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, M2tsSettings> {
        public Builder absentInputAudioBehavior(String var1);

        public Builder absentInputAudioBehavior(M2tsAbsentInputAudioBehavior var1);

        public Builder arib(String var1);

        public Builder arib(M2tsArib var1);

        public Builder aribCaptionsPid(String var1);

        public Builder aribCaptionsPidControl(String var1);

        public Builder aribCaptionsPidControl(M2tsAribCaptionsPidControl var1);

        public Builder audioBufferModel(String var1);

        public Builder audioBufferModel(M2tsAudioBufferModel var1);

        public Builder audioFramesPerPes(Integer var1);

        public Builder audioPids(String var1);

        public Builder audioStreamType(String var1);

        public Builder audioStreamType(M2tsAudioStreamType var1);

        public Builder bitrate(Integer var1);

        public Builder bufferModel(String var1);

        public Builder bufferModel(M2tsBufferModel var1);

        public Builder ccDescriptor(String var1);

        public Builder ccDescriptor(M2tsCcDescriptor var1);

        public Builder dvbNitSettings(DvbNitSettings var1);

        default public Builder dvbNitSettings(Consumer<DvbNitSettings.Builder> dvbNitSettings) {
            return this.dvbNitSettings((DvbNitSettings)((DvbNitSettings.Builder)DvbNitSettings.builder().apply(dvbNitSettings)).build());
        }

        public Builder dvbSdtSettings(DvbSdtSettings var1);

        default public Builder dvbSdtSettings(Consumer<DvbSdtSettings.Builder> dvbSdtSettings) {
            return this.dvbSdtSettings((DvbSdtSettings)((DvbSdtSettings.Builder)DvbSdtSettings.builder().apply(dvbSdtSettings)).build());
        }

        public Builder dvbSubPids(String var1);

        public Builder dvbTdtSettings(DvbTdtSettings var1);

        default public Builder dvbTdtSettings(Consumer<DvbTdtSettings.Builder> dvbTdtSettings) {
            return this.dvbTdtSettings((DvbTdtSettings)((DvbTdtSettings.Builder)DvbTdtSettings.builder().apply(dvbTdtSettings)).build());
        }

        public Builder dvbTeletextPid(String var1);

        public Builder ebif(String var1);

        public Builder ebif(M2tsEbifControl var1);

        public Builder ebpAudioInterval(String var1);

        public Builder ebpAudioInterval(M2tsAudioInterval var1);

        public Builder ebpLookaheadMs(Integer var1);

        public Builder ebpPlacement(String var1);

        public Builder ebpPlacement(M2tsEbpPlacement var1);

        public Builder ecmPid(String var1);

        public Builder esRateInPes(String var1);

        public Builder esRateInPes(M2tsEsRateInPes var1);

        public Builder etvPlatformPid(String var1);

        public Builder etvSignalPid(String var1);

        public Builder fragmentTime(Double var1);

        public Builder klv(String var1);

        public Builder klv(M2tsKlv var1);

        public Builder klvDataPids(String var1);

        public Builder nullPacketBitrate(Double var1);

        public Builder patInterval(Integer var1);

        public Builder pcrControl(String var1);

        public Builder pcrControl(M2tsPcrControl var1);

        public Builder pcrPeriod(Integer var1);

        public Builder pcrPid(String var1);

        public Builder pmtInterval(Integer var1);

        public Builder pmtPid(String var1);

        public Builder programNum(Integer var1);

        public Builder rateMode(String var1);

        public Builder rateMode(M2tsRateMode var1);

        public Builder scte27Pids(String var1);

        public Builder scte35Control(String var1);

        public Builder scte35Control(M2tsScte35Control var1);

        public Builder scte35Pid(String var1);

        public Builder segmentationMarkers(String var1);

        public Builder segmentationMarkers(M2tsSegmentationMarkers var1);

        public Builder segmentationStyle(String var1);

        public Builder segmentationStyle(M2tsSegmentationStyle var1);

        public Builder segmentationTime(Double var1);

        public Builder timedMetadataBehavior(String var1);

        public Builder timedMetadataBehavior(M2tsTimedMetadataBehavior var1);

        public Builder timedMetadataPid(String var1);

        public Builder transportStreamId(Integer var1);

        public Builder videoPid(String var1);
    }
}

