/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioSelector;
import software.amazon.awssdk.services.medialive.model.CaptionSelector;
import software.amazon.awssdk.services.medialive.model.InputDeblockFilter;
import software.amazon.awssdk.services.medialive.model.InputDenoiseFilter;
import software.amazon.awssdk.services.medialive.model.InputFilter;
import software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior;
import software.amazon.awssdk.services.medialive.model.ListOfAudioSelectorCopier;
import software.amazon.awssdk.services.medialive.model.ListOfCaptionSelectorCopier;
import software.amazon.awssdk.services.medialive.model.NetworkInputSettings;
import software.amazon.awssdk.services.medialive.model.VideoSelector;
import software.amazon.awssdk.services.medialive.transform.InputSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, InputSettings> {
    private final List<AudioSelector> audioSelectors;
    private final List<CaptionSelector> captionSelectors;
    private final String deblockFilter;
    private final String denoiseFilter;
    private final Integer filterStrength;
    private final String inputFilter;
    private final NetworkInputSettings networkInputSettings;
    private final String sourceEndBehavior;
    private final VideoSelector videoSelector;

    private InputSettings(BuilderImpl builder) {
        this.audioSelectors = builder.audioSelectors;
        this.captionSelectors = builder.captionSelectors;
        this.deblockFilter = builder.deblockFilter;
        this.denoiseFilter = builder.denoiseFilter;
        this.filterStrength = builder.filterStrength;
        this.inputFilter = builder.inputFilter;
        this.networkInputSettings = builder.networkInputSettings;
        this.sourceEndBehavior = builder.sourceEndBehavior;
        this.videoSelector = builder.videoSelector;
    }

    public List<AudioSelector> audioSelectors() {
        return this.audioSelectors;
    }

    public List<CaptionSelector> captionSelectors() {
        return this.captionSelectors;
    }

    public InputDeblockFilter deblockFilter() {
        return InputDeblockFilter.fromValue(this.deblockFilter);
    }

    public String deblockFilterAsString() {
        return this.deblockFilter;
    }

    public InputDenoiseFilter denoiseFilter() {
        return InputDenoiseFilter.fromValue(this.denoiseFilter);
    }

    public String denoiseFilterAsString() {
        return this.denoiseFilter;
    }

    public Integer filterStrength() {
        return this.filterStrength;
    }

    public InputFilter inputFilter() {
        return InputFilter.fromValue(this.inputFilter);
    }

    public String inputFilterAsString() {
        return this.inputFilter;
    }

    public NetworkInputSettings networkInputSettings() {
        return this.networkInputSettings;
    }

    public InputSourceEndBehavior sourceEndBehavior() {
        return InputSourceEndBehavior.fromValue(this.sourceEndBehavior);
    }

    public String sourceEndBehaviorAsString() {
        return this.sourceEndBehavior;
    }

    public VideoSelector videoSelector() {
        return this.videoSelector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.deblockFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.denoiseFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterStrength());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSelector());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSettings)) {
            return false;
        }
        InputSettings other = (InputSettings)obj;
        return Objects.equals(this.audioSelectors(), other.audioSelectors()) && Objects.equals(this.captionSelectors(), other.captionSelectors()) && Objects.equals(this.deblockFilterAsString(), other.deblockFilterAsString()) && Objects.equals(this.denoiseFilterAsString(), other.denoiseFilterAsString()) && Objects.equals(this.filterStrength(), other.filterStrength()) && Objects.equals(this.inputFilterAsString(), other.inputFilterAsString()) && Objects.equals(this.networkInputSettings(), other.networkInputSettings()) && Objects.equals(this.sourceEndBehaviorAsString(), other.sourceEndBehaviorAsString()) && Objects.equals(this.videoSelector(), other.videoSelector());
    }

    public String toString() {
        return ToString.builder((String)"InputSettings").add("AudioSelectors", this.audioSelectors()).add("CaptionSelectors", this.captionSelectors()).add("DeblockFilter", (Object)this.deblockFilterAsString()).add("DenoiseFilter", (Object)this.denoiseFilterAsString()).add("FilterStrength", (Object)this.filterStrength()).add("InputFilter", (Object)this.inputFilterAsString()).add("NetworkInputSettings", (Object)this.networkInputSettings()).add("SourceEndBehavior", (Object)this.sourceEndBehaviorAsString()).add("VideoSelector", (Object)this.videoSelector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioSelectors": {
                return Optional.of(clazz.cast(this.audioSelectors()));
            }
            case "CaptionSelectors": {
                return Optional.of(clazz.cast(this.captionSelectors()));
            }
            case "DeblockFilter": {
                return Optional.of(clazz.cast(this.deblockFilterAsString()));
            }
            case "DenoiseFilter": {
                return Optional.of(clazz.cast(this.denoiseFilterAsString()));
            }
            case "FilterStrength": {
                return Optional.of(clazz.cast(this.filterStrength()));
            }
            case "InputFilter": {
                return Optional.of(clazz.cast(this.inputFilterAsString()));
            }
            case "NetworkInputSettings": {
                return Optional.of(clazz.cast(this.networkInputSettings()));
            }
            case "SourceEndBehavior": {
                return Optional.of(clazz.cast(this.sourceEndBehaviorAsString()));
            }
            case "VideoSelector": {
                return Optional.of(clazz.cast(this.videoSelector()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioSelector> audioSelectors;
        private List<CaptionSelector> captionSelectors;
        private String deblockFilter;
        private String denoiseFilter;
        private Integer filterStrength;
        private String inputFilter;
        private NetworkInputSettings networkInputSettings;
        private String sourceEndBehavior;
        private VideoSelector videoSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSettings model) {
            this.audioSelectors(model.audioSelectors);
            this.captionSelectors(model.captionSelectors);
            this.deblockFilter(model.deblockFilter);
            this.denoiseFilter(model.denoiseFilter);
            this.filterStrength(model.filterStrength);
            this.inputFilter(model.inputFilter);
            this.networkInputSettings(model.networkInputSettings);
            this.sourceEndBehavior(model.sourceEndBehavior);
            this.videoSelector(model.videoSelector);
        }

        public final Collection<AudioSelector.Builder> getAudioSelectors() {
            return this.audioSelectors != null ? (Collection)this.audioSelectors.stream().map(AudioSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioSelectors(Collection<AudioSelector> audioSelectors) {
            this.audioSelectors = ListOfAudioSelectorCopier.copy(audioSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioSelectors(AudioSelector ... audioSelectors) {
            this.audioSelectors(Arrays.asList(audioSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioSelectors(Consumer<AudioSelector.Builder> ... audioSelectors) {
            this.audioSelectors(Stream.of(audioSelectors).map(c -> (AudioSelector)((AudioSelector.Builder)AudioSelector.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioSelectors(Collection<AudioSelector.BuilderImpl> audioSelectors) {
            this.audioSelectors = ListOfAudioSelectorCopier.copyFromBuilder(audioSelectors);
        }

        public final Collection<CaptionSelector.Builder> getCaptionSelectors() {
            return this.captionSelectors != null ? (Collection)this.captionSelectors.stream().map(CaptionSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionSelectors(Collection<CaptionSelector> captionSelectors) {
            this.captionSelectors = ListOfCaptionSelectorCopier.copy(captionSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSelectors(CaptionSelector ... captionSelectors) {
            this.captionSelectors(Arrays.asList(captionSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSelectors(Consumer<CaptionSelector.Builder> ... captionSelectors) {
            this.captionSelectors(Stream.of(captionSelectors).map(c -> (CaptionSelector)((CaptionSelector.Builder)CaptionSelector.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionSelectors(Collection<CaptionSelector.BuilderImpl> captionSelectors) {
            this.captionSelectors = ListOfCaptionSelectorCopier.copyFromBuilder(captionSelectors);
        }

        public final String getDeblockFilter() {
            return this.deblockFilter;
        }

        @Override
        public final Builder deblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
            return this;
        }

        @Override
        public final Builder deblockFilter(InputDeblockFilter deblockFilter) {
            this.deblockFilter(deblockFilter.toString());
            return this;
        }

        public final void setDeblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
        }

        public final String getDenoiseFilter() {
            return this.denoiseFilter;
        }

        @Override
        public final Builder denoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
            return this;
        }

        @Override
        public final Builder denoiseFilter(InputDenoiseFilter denoiseFilter) {
            this.denoiseFilter(denoiseFilter.toString());
            return this;
        }

        public final void setDenoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
        }

        public final Integer getFilterStrength() {
            return this.filterStrength;
        }

        @Override
        public final Builder filterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        public final void setFilterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
        }

        public final String getInputFilter() {
            return this.inputFilter;
        }

        @Override
        public final Builder inputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
            return this;
        }

        @Override
        public final Builder inputFilter(InputFilter inputFilter) {
            this.inputFilter(inputFilter.toString());
            return this;
        }

        public final void setInputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
        }

        public final NetworkInputSettings.Builder getNetworkInputSettings() {
            return this.networkInputSettings != null ? this.networkInputSettings.toBuilder() : null;
        }

        @Override
        public final Builder networkInputSettings(NetworkInputSettings networkInputSettings) {
            this.networkInputSettings = networkInputSettings;
            return this;
        }

        public final void setNetworkInputSettings(NetworkInputSettings.BuilderImpl networkInputSettings) {
            this.networkInputSettings = networkInputSettings != null ? networkInputSettings.build() : null;
        }

        public final String getSourceEndBehavior() {
            return this.sourceEndBehavior;
        }

        @Override
        public final Builder sourceEndBehavior(String sourceEndBehavior) {
            this.sourceEndBehavior = sourceEndBehavior;
            return this;
        }

        @Override
        public final Builder sourceEndBehavior(InputSourceEndBehavior sourceEndBehavior) {
            this.sourceEndBehavior(sourceEndBehavior.toString());
            return this;
        }

        public final void setSourceEndBehavior(String sourceEndBehavior) {
            this.sourceEndBehavior = sourceEndBehavior;
        }

        public final VideoSelector.Builder getVideoSelector() {
            return this.videoSelector != null ? this.videoSelector.toBuilder() : null;
        }

        @Override
        public final Builder videoSelector(VideoSelector videoSelector) {
            this.videoSelector = videoSelector;
            return this;
        }

        public final void setVideoSelector(VideoSelector.BuilderImpl videoSelector) {
            this.videoSelector = videoSelector != null ? videoSelector.build() : null;
        }

        public InputSettings build() {
            return new InputSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputSettings> {
        public Builder audioSelectors(Collection<AudioSelector> var1);

        public Builder audioSelectors(AudioSelector ... var1);

        public Builder audioSelectors(Consumer<AudioSelector.Builder> ... var1);

        public Builder captionSelectors(Collection<CaptionSelector> var1);

        public Builder captionSelectors(CaptionSelector ... var1);

        public Builder captionSelectors(Consumer<CaptionSelector.Builder> ... var1);

        public Builder deblockFilter(String var1);

        public Builder deblockFilter(InputDeblockFilter var1);

        public Builder denoiseFilter(String var1);

        public Builder denoiseFilter(InputDenoiseFilter var1);

        public Builder filterStrength(Integer var1);

        public Builder inputFilter(String var1);

        public Builder inputFilter(InputFilter var1);

        public Builder networkInputSettings(NetworkInputSettings var1);

        default public Builder networkInputSettings(Consumer<NetworkInputSettings.Builder> networkInputSettings) {
            return this.networkInputSettings((NetworkInputSettings)((NetworkInputSettings.Builder)NetworkInputSettings.builder().apply(networkInputSettings)).build());
        }

        public Builder sourceEndBehavior(String var1);

        public Builder sourceEndBehavior(InputSourceEndBehavior var1);

        public Builder videoSelector(VideoSelector var1);

        default public Builder videoSelector(Consumer<VideoSelector.Builder> videoSelector) {
            return this.videoSelector((VideoSelector)((VideoSelector.Builder)VideoSelector.builder().apply(videoSelector)).build());
        }
    }
}

