/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.services.medialive.model.InputLossImageType;
import software.amazon.awssdk.services.medialive.transform.InputLossBehaviorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputLossBehavior
implements StructuredPojo,
ToCopyableBuilder<Builder, InputLossBehavior> {
    private final Integer blackFrameMsec;
    private final String inputLossImageColor;
    private final InputLocation inputLossImageSlate;
    private final String inputLossImageType;
    private final Integer repeatFrameMsec;

    private InputLossBehavior(BuilderImpl builder) {
        this.blackFrameMsec = builder.blackFrameMsec;
        this.inputLossImageColor = builder.inputLossImageColor;
        this.inputLossImageSlate = builder.inputLossImageSlate;
        this.inputLossImageType = builder.inputLossImageType;
        this.repeatFrameMsec = builder.repeatFrameMsec;
    }

    public Integer blackFrameMsec() {
        return this.blackFrameMsec;
    }

    public String inputLossImageColor() {
        return this.inputLossImageColor;
    }

    public InputLocation inputLossImageSlate() {
        return this.inputLossImageSlate;
    }

    public InputLossImageType inputLossImageType() {
        return InputLossImageType.fromValue(this.inputLossImageType);
    }

    public String inputLossImageTypeAsString() {
        return this.inputLossImageType;
    }

    public Integer repeatFrameMsec() {
        return this.repeatFrameMsec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blackFrameMsec());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossImageColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossImageSlate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossImageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repeatFrameMsec());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLossBehavior)) {
            return false;
        }
        InputLossBehavior other = (InputLossBehavior)obj;
        return Objects.equals(this.blackFrameMsec(), other.blackFrameMsec()) && Objects.equals(this.inputLossImageColor(), other.inputLossImageColor()) && Objects.equals(this.inputLossImageSlate(), other.inputLossImageSlate()) && Objects.equals(this.inputLossImageTypeAsString(), other.inputLossImageTypeAsString()) && Objects.equals(this.repeatFrameMsec(), other.repeatFrameMsec());
    }

    public String toString() {
        return ToString.builder((String)"InputLossBehavior").add("BlackFrameMsec", (Object)this.blackFrameMsec()).add("InputLossImageColor", (Object)this.inputLossImageColor()).add("InputLossImageSlate", (Object)this.inputLossImageSlate()).add("InputLossImageType", (Object)this.inputLossImageTypeAsString()).add("RepeatFrameMsec", (Object)this.repeatFrameMsec()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlackFrameMsec": {
                return Optional.of(clazz.cast(this.blackFrameMsec()));
            }
            case "InputLossImageColor": {
                return Optional.of(clazz.cast(this.inputLossImageColor()));
            }
            case "InputLossImageSlate": {
                return Optional.of(clazz.cast(this.inputLossImageSlate()));
            }
            case "InputLossImageType": {
                return Optional.of(clazz.cast(this.inputLossImageTypeAsString()));
            }
            case "RepeatFrameMsec": {
                return Optional.of(clazz.cast(this.repeatFrameMsec()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputLossBehaviorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer blackFrameMsec;
        private String inputLossImageColor;
        private InputLocation inputLossImageSlate;
        private String inputLossImageType;
        private Integer repeatFrameMsec;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLossBehavior model) {
            this.blackFrameMsec(model.blackFrameMsec);
            this.inputLossImageColor(model.inputLossImageColor);
            this.inputLossImageSlate(model.inputLossImageSlate);
            this.inputLossImageType(model.inputLossImageType);
            this.repeatFrameMsec(model.repeatFrameMsec);
        }

        public final Integer getBlackFrameMsec() {
            return this.blackFrameMsec;
        }

        @Override
        public final Builder blackFrameMsec(Integer blackFrameMsec) {
            this.blackFrameMsec = blackFrameMsec;
            return this;
        }

        public final void setBlackFrameMsec(Integer blackFrameMsec) {
            this.blackFrameMsec = blackFrameMsec;
        }

        public final String getInputLossImageColor() {
            return this.inputLossImageColor;
        }

        @Override
        public final Builder inputLossImageColor(String inputLossImageColor) {
            this.inputLossImageColor = inputLossImageColor;
            return this;
        }

        public final void setInputLossImageColor(String inputLossImageColor) {
            this.inputLossImageColor = inputLossImageColor;
        }

        public final InputLocation.Builder getInputLossImageSlate() {
            return this.inputLossImageSlate != null ? this.inputLossImageSlate.toBuilder() : null;
        }

        @Override
        public final Builder inputLossImageSlate(InputLocation inputLossImageSlate) {
            this.inputLossImageSlate = inputLossImageSlate;
            return this;
        }

        public final void setInputLossImageSlate(InputLocation.BuilderImpl inputLossImageSlate) {
            this.inputLossImageSlate = inputLossImageSlate != null ? inputLossImageSlate.build() : null;
        }

        public final String getInputLossImageType() {
            return this.inputLossImageType;
        }

        @Override
        public final Builder inputLossImageType(String inputLossImageType) {
            this.inputLossImageType = inputLossImageType;
            return this;
        }

        @Override
        public final Builder inputLossImageType(InputLossImageType inputLossImageType) {
            this.inputLossImageType(inputLossImageType.toString());
            return this;
        }

        public final void setInputLossImageType(String inputLossImageType) {
            this.inputLossImageType = inputLossImageType;
        }

        public final Integer getRepeatFrameMsec() {
            return this.repeatFrameMsec;
        }

        @Override
        public final Builder repeatFrameMsec(Integer repeatFrameMsec) {
            this.repeatFrameMsec = repeatFrameMsec;
            return this;
        }

        public final void setRepeatFrameMsec(Integer repeatFrameMsec) {
            this.repeatFrameMsec = repeatFrameMsec;
        }

        public InputLossBehavior build() {
            return new InputLossBehavior(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputLossBehavior> {
        public Builder blackFrameMsec(Integer var1);

        public Builder inputLossImageColor(String var1);

        public Builder inputLossImageSlate(InputLocation var1);

        default public Builder inputLossImageSlate(Consumer<InputLocation.Builder> inputLossImageSlate) {
            return this.inputLossImageSlate((InputLocation)((InputLocation.Builder)InputLocation.builder().apply(inputLossImageSlate)).build());
        }

        public Builder inputLossImageType(String var1);

        public Builder inputLossImageType(InputLossImageType var1);

        public Builder repeatFrameMsec(Integer var1);
    }
}

