/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputSettings;
import software.amazon.awssdk.services.medialive.transform.InputAttachmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputAttachment
implements StructuredPojo,
ToCopyableBuilder<Builder, InputAttachment> {
    private final String inputId;
    private final InputSettings inputSettings;

    private InputAttachment(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.inputSettings = builder.inputSettings;
    }

    public String inputId() {
        return this.inputId;
    }

    public InputSettings inputSettings() {
        return this.inputSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputAttachment)) {
            return false;
        }
        InputAttachment other = (InputAttachment)obj;
        return Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.inputSettings(), other.inputSettings());
    }

    public String toString() {
        return ToString.builder((String)"InputAttachment").add("InputId", (Object)this.inputId()).add("InputSettings", (Object)this.inputSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputId": {
                return Optional.of(clazz.cast(this.inputId()));
            }
            case "InputSettings": {
                return Optional.of(clazz.cast(this.inputSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputAttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputId;
        private InputSettings inputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(InputAttachment model) {
            this.inputId(model.inputId);
            this.inputSettings(model.inputSettings);
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final InputSettings.Builder getInputSettings() {
            return this.inputSettings != null ? this.inputSettings.toBuilder() : null;
        }

        @Override
        public final Builder inputSettings(InputSettings inputSettings) {
            this.inputSettings = inputSettings;
            return this;
        }

        public final void setInputSettings(InputSettings.BuilderImpl inputSettings) {
            this.inputSettings = inputSettings != null ? inputSettings.build() : null;
        }

        public InputAttachment build() {
            return new InputAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputAttachment> {
        public Builder inputId(String var1);

        public Builder inputSettings(InputSettings var1);

        default public Builder inputSettings(Consumer<InputSettings.Builder> inputSettings) {
            return this.inputSettings((InputSettings)((InputSettings.Builder)InputSettings.builder().apply(inputSettings)).build());
        }
    }
}

