/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputDestination;
import software.amazon.awssdk.services.medialive.model.InputSource;
import software.amazon.awssdk.services.medialive.model.InputState;
import software.amazon.awssdk.services.medialive.model.InputType;
import software.amazon.awssdk.services.medialive.model.ListOfInputDestinationCopier;
import software.amazon.awssdk.services.medialive.model.ListOfInputSourceCopier;
import software.amazon.awssdk.services.medialive.model.ListOf__stringCopier;
import software.amazon.awssdk.services.medialive.transform.InputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Input
implements StructuredPojo,
ToCopyableBuilder<Builder, Input> {
    private final String arn;
    private final List<String> attachedChannels;
    private final List<InputDestination> destinations;
    private final String id;
    private final String name;
    private final List<String> securityGroups;
    private final List<InputSource> sources;
    private final String state;
    private final String type;

    private Input(BuilderImpl builder) {
        this.arn = builder.arn;
        this.attachedChannels = builder.attachedChannels;
        this.destinations = builder.destinations;
        this.id = builder.id;
        this.name = builder.name;
        this.securityGroups = builder.securityGroups;
        this.sources = builder.sources;
        this.state = builder.state;
        this.type = builder.type;
    }

    public String arn() {
        return this.arn;
    }

    public List<String> attachedChannels() {
        return this.attachedChannels;
    }

    public List<InputDestination> destinations() {
        return this.destinations;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public List<InputSource> sources() {
        return this.sources;
    }

    public InputState state() {
        return InputState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public InputType type() {
        return InputType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedChannels());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.sources());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.attachedChannels(), other.attachedChannels()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Input").add("Arn", (Object)this.arn()).add("AttachedChannels", this.attachedChannels()).add("Destinations", this.destinations()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("SecurityGroups", this.securityGroups()).add("Sources", this.sources()).add("State", (Object)this.stateAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "AttachedChannels": {
                return Optional.of(clazz.cast(this.attachedChannels()));
            }
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "Sources": {
                return Optional.of(clazz.cast(this.sources()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> attachedChannels;
        private List<InputDestination> destinations;
        private String id;
        private String name;
        private List<String> securityGroups;
        private List<InputSource> sources;
        private String state;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            this.arn(model.arn);
            this.attachedChannels(model.attachedChannels);
            this.destinations(model.destinations);
            this.id(model.id);
            this.name(model.name);
            this.securityGroups(model.securityGroups);
            this.sources(model.sources);
            this.state(model.state);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getAttachedChannels() {
            return this.attachedChannels;
        }

        @Override
        public final Builder attachedChannels(Collection<String> attachedChannels) {
            this.attachedChannels = ListOf__stringCopier.copy(attachedChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedChannels(String ... attachedChannels) {
            this.attachedChannels(Arrays.asList(attachedChannels));
            return this;
        }

        public final void setAttachedChannels(Collection<String> attachedChannels) {
            this.attachedChannels = ListOf__stringCopier.copy(attachedChannels);
        }

        public final Collection<InputDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(InputDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<InputDestination> destinations) {
            this.destinations = ListOfInputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (InputDestination)((InputDestination.Builder)InputDestination.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<InputDestination.BuilderImpl> destinations) {
            this.destinations = ListOfInputDestinationCopier.copyFromBuilder(destinations);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ListOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ListOf__stringCopier.copy(securityGroups);
        }

        public final Collection<InputSource.Builder> getSources() {
            return this.sources != null ? (Collection)this.sources.stream().map(InputSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<InputSource> sources) {
            this.sources = ListOfInputSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (InputSource)((InputSource.Builder)InputSource.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<InputSource.BuilderImpl> sources) {
            this.sources = ListOfInputSourceCopier.copyFromBuilder(sources);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InputState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Input build() {
            return new Input(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Input> {
        public Builder arn(String var1);

        public Builder attachedChannels(Collection<String> var1);

        public Builder attachedChannels(String ... var1);

        public Builder destinations(Collection<InputDestination> var1);

        public Builder destinations(InputDestination ... var1);

        public Builder destinations(Consumer<InputDestination.Builder> ... var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder sources(Collection<InputSource> var1);

        public Builder sources(InputSource ... var1);

        public Builder sources(Consumer<InputSource.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(InputState var1);

        public Builder type(String var1);

        public Builder type(InputType var1);
    }
}

