/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsWebdavHttpTransferMode;
import software.amazon.awssdk.services.medialive.transform.HlsWebdavSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsWebdavSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsWebdavSettings> {
    private final Integer connectionRetryInterval;
    private final Integer filecacheDuration;
    private final String httpTransferMode;
    private final Integer numRetries;
    private final Integer restartDelay;

    private HlsWebdavSettings(BuilderImpl builder) {
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.filecacheDuration = builder.filecacheDuration;
        this.httpTransferMode = builder.httpTransferMode;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
    }

    public Integer connectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public Integer filecacheDuration() {
        return this.filecacheDuration;
    }

    public HlsWebdavHttpTransferMode httpTransferMode() {
        return HlsWebdavHttpTransferMode.fromValue(this.httpTransferMode);
    }

    public String httpTransferModeAsString() {
        return this.httpTransferMode;
    }

    public Integer numRetries() {
        return this.numRetries;
    }

    public Integer restartDelay() {
        return this.restartDelay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTransferModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsWebdavSettings)) {
            return false;
        }
        HlsWebdavSettings other = (HlsWebdavSettings)obj;
        return Objects.equals(this.connectionRetryInterval(), other.connectionRetryInterval()) && Objects.equals(this.filecacheDuration(), other.filecacheDuration()) && Objects.equals(this.httpTransferModeAsString(), other.httpTransferModeAsString()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.restartDelay(), other.restartDelay());
    }

    public String toString() {
        return ToString.builder((String)"HlsWebdavSettings").add("ConnectionRetryInterval", (Object)this.connectionRetryInterval()).add("FilecacheDuration", (Object)this.filecacheDuration()).add("HttpTransferMode", (Object)this.httpTransferModeAsString()).add("NumRetries", (Object)this.numRetries()).add("RestartDelay", (Object)this.restartDelay()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionRetryInterval": {
                return Optional.of(clazz.cast(this.connectionRetryInterval()));
            }
            case "FilecacheDuration": {
                return Optional.of(clazz.cast(this.filecacheDuration()));
            }
            case "HttpTransferMode": {
                return Optional.of(clazz.cast(this.httpTransferModeAsString()));
            }
            case "NumRetries": {
                return Optional.of(clazz.cast(this.numRetries()));
            }
            case "RestartDelay": {
                return Optional.of(clazz.cast(this.restartDelay()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsWebdavSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer connectionRetryInterval;
        private Integer filecacheDuration;
        private String httpTransferMode;
        private Integer numRetries;
        private Integer restartDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsWebdavSettings model) {
            this.connectionRetryInterval(model.connectionRetryInterval);
            this.filecacheDuration(model.filecacheDuration);
            this.httpTransferMode(model.httpTransferMode);
            this.numRetries(model.numRetries);
            this.restartDelay(model.restartDelay);
        }

        public final Integer getConnectionRetryInterval() {
            return this.connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public final Integer getFilecacheDuration() {
            return this.filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        public final String getHttpTransferMode() {
            return this.httpTransferMode;
        }

        @Override
        public final Builder httpTransferMode(String httpTransferMode) {
            this.httpTransferMode = httpTransferMode;
            return this;
        }

        @Override
        public final Builder httpTransferMode(HlsWebdavHttpTransferMode httpTransferMode) {
            this.httpTransferMode(httpTransferMode.toString());
            return this;
        }

        public final void setHttpTransferMode(String httpTransferMode) {
            this.httpTransferMode = httpTransferMode;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        public HlsWebdavSettings build() {
            return new HlsWebdavSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsWebdavSettings> {
        public Builder connectionRetryInterval(Integer var1);

        public Builder filecacheDuration(Integer var1);

        public Builder httpTransferMode(String var1);

        public Builder httpTransferMode(HlsWebdavHttpTransferMode var1);

        public Builder numRetries(Integer var1);

        public Builder restartDelay(Integer var1);
    }
}

