/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.transform.HlsInputSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsInputSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsInputSettings> {
    private final Integer bandwidth;
    private final Integer bufferSegments;
    private final Integer retries;
    private final Integer retryInterval;

    private HlsInputSettings(BuilderImpl builder) {
        this.bandwidth = builder.bandwidth;
        this.bufferSegments = builder.bufferSegments;
        this.retries = builder.retries;
        this.retryInterval = builder.retryInterval;
    }

    public Integer bandwidth() {
        return this.bandwidth;
    }

    public Integer bufferSegments() {
        return this.bufferSegments;
    }

    public Integer retries() {
        return this.retries;
    }

    public Integer retryInterval() {
        return this.retryInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferSegments());
        hashCode = 31 * hashCode + Objects.hashCode(this.retries());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryInterval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsInputSettings)) {
            return false;
        }
        HlsInputSettings other = (HlsInputSettings)obj;
        return Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.bufferSegments(), other.bufferSegments()) && Objects.equals(this.retries(), other.retries()) && Objects.equals(this.retryInterval(), other.retryInterval());
    }

    public String toString() {
        return ToString.builder((String)"HlsInputSettings").add("Bandwidth", (Object)this.bandwidth()).add("BufferSegments", (Object)this.bufferSegments()).add("Retries", (Object)this.retries()).add("RetryInterval", (Object)this.retryInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bandwidth": {
                return Optional.of(clazz.cast(this.bandwidth()));
            }
            case "BufferSegments": {
                return Optional.of(clazz.cast(this.bufferSegments()));
            }
            case "Retries": {
                return Optional.of(clazz.cast(this.retries()));
            }
            case "RetryInterval": {
                return Optional.of(clazz.cast(this.retryInterval()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsInputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bandwidth;
        private Integer bufferSegments;
        private Integer retries;
        private Integer retryInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsInputSettings model) {
            this.bandwidth(model.bandwidth);
            this.bufferSegments(model.bufferSegments);
            this.retries(model.retries);
            this.retryInterval(model.retryInterval);
        }

        public final Integer getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Integer getBufferSegments() {
            return this.bufferSegments;
        }

        @Override
        public final Builder bufferSegments(Integer bufferSegments) {
            this.bufferSegments = bufferSegments;
            return this;
        }

        public final void setBufferSegments(Integer bufferSegments) {
            this.bufferSegments = bufferSegments;
        }

        public final Integer getRetries() {
            return this.retries;
        }

        @Override
        public final Builder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public final void setRetries(Integer retries) {
            this.retries = retries;
        }

        public final Integer getRetryInterval() {
            return this.retryInterval;
        }

        @Override
        public final Builder retryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public final void setRetryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
        }

        public HlsInputSettings build() {
            return new HlsInputSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsInputSettings> {
        public Builder bandwidth(Integer var1);

        public Builder bufferSegments(Integer var1);

        public Builder retries(Integer var1);

        public Builder retryInterval(Integer var1);
    }
}

