/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsAkamaiSettings;
import software.amazon.awssdk.services.medialive.model.HlsBasicPutSettings;
import software.amazon.awssdk.services.medialive.model.HlsMediaStoreSettings;
import software.amazon.awssdk.services.medialive.model.HlsWebdavSettings;
import software.amazon.awssdk.services.medialive.transform.HlsCdnSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsCdnSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsCdnSettings> {
    private final HlsAkamaiSettings hlsAkamaiSettings;
    private final HlsBasicPutSettings hlsBasicPutSettings;
    private final HlsMediaStoreSettings hlsMediaStoreSettings;
    private final HlsWebdavSettings hlsWebdavSettings;

    private HlsCdnSettings(BuilderImpl builder) {
        this.hlsAkamaiSettings = builder.hlsAkamaiSettings;
        this.hlsBasicPutSettings = builder.hlsBasicPutSettings;
        this.hlsMediaStoreSettings = builder.hlsMediaStoreSettings;
        this.hlsWebdavSettings = builder.hlsWebdavSettings;
    }

    public HlsAkamaiSettings hlsAkamaiSettings() {
        return this.hlsAkamaiSettings;
    }

    public HlsBasicPutSettings hlsBasicPutSettings() {
        return this.hlsBasicPutSettings;
    }

    public HlsMediaStoreSettings hlsMediaStoreSettings() {
        return this.hlsMediaStoreSettings;
    }

    public HlsWebdavSettings hlsWebdavSettings() {
        return this.hlsWebdavSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsAkamaiSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsBasicPutSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsMediaStoreSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsWebdavSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsCdnSettings)) {
            return false;
        }
        HlsCdnSettings other = (HlsCdnSettings)obj;
        return Objects.equals(this.hlsAkamaiSettings(), other.hlsAkamaiSettings()) && Objects.equals(this.hlsBasicPutSettings(), other.hlsBasicPutSettings()) && Objects.equals(this.hlsMediaStoreSettings(), other.hlsMediaStoreSettings()) && Objects.equals(this.hlsWebdavSettings(), other.hlsWebdavSettings());
    }

    public String toString() {
        return ToString.builder((String)"HlsCdnSettings").add("HlsAkamaiSettings", (Object)this.hlsAkamaiSettings()).add("HlsBasicPutSettings", (Object)this.hlsBasicPutSettings()).add("HlsMediaStoreSettings", (Object)this.hlsMediaStoreSettings()).add("HlsWebdavSettings", (Object)this.hlsWebdavSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HlsAkamaiSettings": {
                return Optional.of(clazz.cast(this.hlsAkamaiSettings()));
            }
            case "HlsBasicPutSettings": {
                return Optional.of(clazz.cast(this.hlsBasicPutSettings()));
            }
            case "HlsMediaStoreSettings": {
                return Optional.of(clazz.cast(this.hlsMediaStoreSettings()));
            }
            case "HlsWebdavSettings": {
                return Optional.of(clazz.cast(this.hlsWebdavSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsCdnSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private HlsAkamaiSettings hlsAkamaiSettings;
        private HlsBasicPutSettings hlsBasicPutSettings;
        private HlsMediaStoreSettings hlsMediaStoreSettings;
        private HlsWebdavSettings hlsWebdavSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsCdnSettings model) {
            this.hlsAkamaiSettings(model.hlsAkamaiSettings);
            this.hlsBasicPutSettings(model.hlsBasicPutSettings);
            this.hlsMediaStoreSettings(model.hlsMediaStoreSettings);
            this.hlsWebdavSettings(model.hlsWebdavSettings);
        }

        public final HlsAkamaiSettings.Builder getHlsAkamaiSettings() {
            return this.hlsAkamaiSettings != null ? this.hlsAkamaiSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsAkamaiSettings(HlsAkamaiSettings hlsAkamaiSettings) {
            this.hlsAkamaiSettings = hlsAkamaiSettings;
            return this;
        }

        public final void setHlsAkamaiSettings(HlsAkamaiSettings.BuilderImpl hlsAkamaiSettings) {
            this.hlsAkamaiSettings = hlsAkamaiSettings != null ? hlsAkamaiSettings.build() : null;
        }

        public final HlsBasicPutSettings.Builder getHlsBasicPutSettings() {
            return this.hlsBasicPutSettings != null ? this.hlsBasicPutSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsBasicPutSettings(HlsBasicPutSettings hlsBasicPutSettings) {
            this.hlsBasicPutSettings = hlsBasicPutSettings;
            return this;
        }

        public final void setHlsBasicPutSettings(HlsBasicPutSettings.BuilderImpl hlsBasicPutSettings) {
            this.hlsBasicPutSettings = hlsBasicPutSettings != null ? hlsBasicPutSettings.build() : null;
        }

        public final HlsMediaStoreSettings.Builder getHlsMediaStoreSettings() {
            return this.hlsMediaStoreSettings != null ? this.hlsMediaStoreSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsMediaStoreSettings(HlsMediaStoreSettings hlsMediaStoreSettings) {
            this.hlsMediaStoreSettings = hlsMediaStoreSettings;
            return this;
        }

        public final void setHlsMediaStoreSettings(HlsMediaStoreSettings.BuilderImpl hlsMediaStoreSettings) {
            this.hlsMediaStoreSettings = hlsMediaStoreSettings != null ? hlsMediaStoreSettings.build() : null;
        }

        public final HlsWebdavSettings.Builder getHlsWebdavSettings() {
            return this.hlsWebdavSettings != null ? this.hlsWebdavSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsWebdavSettings(HlsWebdavSettings hlsWebdavSettings) {
            this.hlsWebdavSettings = hlsWebdavSettings;
            return this;
        }

        public final void setHlsWebdavSettings(HlsWebdavSettings.BuilderImpl hlsWebdavSettings) {
            this.hlsWebdavSettings = hlsWebdavSettings != null ? hlsWebdavSettings.build() : null;
        }

        public HlsCdnSettings build() {
            return new HlsCdnSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsCdnSettings> {
        public Builder hlsAkamaiSettings(HlsAkamaiSettings var1);

        default public Builder hlsAkamaiSettings(Consumer<HlsAkamaiSettings.Builder> hlsAkamaiSettings) {
            return this.hlsAkamaiSettings((HlsAkamaiSettings)((HlsAkamaiSettings.Builder)HlsAkamaiSettings.builder().apply(hlsAkamaiSettings)).build());
        }

        public Builder hlsBasicPutSettings(HlsBasicPutSettings var1);

        default public Builder hlsBasicPutSettings(Consumer<HlsBasicPutSettings.Builder> hlsBasicPutSettings) {
            return this.hlsBasicPutSettings((HlsBasicPutSettings)((HlsBasicPutSettings.Builder)HlsBasicPutSettings.builder().apply(hlsBasicPutSettings)).build());
        }

        public Builder hlsMediaStoreSettings(HlsMediaStoreSettings var1);

        default public Builder hlsMediaStoreSettings(Consumer<HlsMediaStoreSettings.Builder> hlsMediaStoreSettings) {
            return this.hlsMediaStoreSettings((HlsMediaStoreSettings)((HlsMediaStoreSettings.Builder)HlsMediaStoreSettings.builder().apply(hlsMediaStoreSettings)).build());
        }

        public Builder hlsWebdavSettings(HlsWebdavSettings var1);

        default public Builder hlsWebdavSettings(Consumer<HlsWebdavSettings.Builder> hlsWebdavSettings) {
            return this.hlsWebdavSettings((HlsWebdavSettings)((HlsWebdavSettings.Builder)HlsWebdavSettings.builder().apply(hlsWebdavSettings)).build());
        }
    }
}

