/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.transform.HlsBasicPutSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsBasicPutSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsBasicPutSettings> {
    private final Integer connectionRetryInterval;
    private final Integer filecacheDuration;
    private final Integer numRetries;
    private final Integer restartDelay;

    private HlsBasicPutSettings(BuilderImpl builder) {
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.filecacheDuration = builder.filecacheDuration;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
    }

    public Integer connectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public Integer filecacheDuration() {
        return this.filecacheDuration;
    }

    public Integer numRetries() {
        return this.numRetries;
    }

    public Integer restartDelay() {
        return this.restartDelay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsBasicPutSettings)) {
            return false;
        }
        HlsBasicPutSettings other = (HlsBasicPutSettings)obj;
        return Objects.equals(this.connectionRetryInterval(), other.connectionRetryInterval()) && Objects.equals(this.filecacheDuration(), other.filecacheDuration()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.restartDelay(), other.restartDelay());
    }

    public String toString() {
        return ToString.builder((String)"HlsBasicPutSettings").add("ConnectionRetryInterval", (Object)this.connectionRetryInterval()).add("FilecacheDuration", (Object)this.filecacheDuration()).add("NumRetries", (Object)this.numRetries()).add("RestartDelay", (Object)this.restartDelay()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionRetryInterval": {
                return Optional.of(clazz.cast(this.connectionRetryInterval()));
            }
            case "FilecacheDuration": {
                return Optional.of(clazz.cast(this.filecacheDuration()));
            }
            case "NumRetries": {
                return Optional.of(clazz.cast(this.numRetries()));
            }
            case "RestartDelay": {
                return Optional.of(clazz.cast(this.restartDelay()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsBasicPutSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer connectionRetryInterval;
        private Integer filecacheDuration;
        private Integer numRetries;
        private Integer restartDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsBasicPutSettings model) {
            this.connectionRetryInterval(model.connectionRetryInterval);
            this.filecacheDuration(model.filecacheDuration);
            this.numRetries(model.numRetries);
            this.restartDelay(model.restartDelay);
        }

        public final Integer getConnectionRetryInterval() {
            return this.connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public final Integer getFilecacheDuration() {
            return this.filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        public HlsBasicPutSettings build() {
            return new HlsBasicPutSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsBasicPutSettings> {
        public Builder connectionRetryInterval(Integer var1);

        public Builder filecacheDuration(Integer var1);

        public Builder numRetries(Integer var1);

        public Builder restartDelay(Integer var1);
    }
}

