/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.FecOutputIncludeFec;
import software.amazon.awssdk.services.medialive.transform.FecOutputSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FecOutputSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, FecOutputSettings> {
    private final Integer columnDepth;
    private final String includeFec;
    private final Integer rowLength;

    private FecOutputSettings(BuilderImpl builder) {
        this.columnDepth = builder.columnDepth;
        this.includeFec = builder.includeFec;
        this.rowLength = builder.rowLength;
    }

    public Integer columnDepth() {
        return this.columnDepth;
    }

    public FecOutputIncludeFec includeFec() {
        return FecOutputIncludeFec.fromValue(this.includeFec);
    }

    public String includeFecAsString() {
        return this.includeFec;
    }

    public Integer rowLength() {
        return this.rowLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeFecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowLength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FecOutputSettings)) {
            return false;
        }
        FecOutputSettings other = (FecOutputSettings)obj;
        return Objects.equals(this.columnDepth(), other.columnDepth()) && Objects.equals(this.includeFecAsString(), other.includeFecAsString()) && Objects.equals(this.rowLength(), other.rowLength());
    }

    public String toString() {
        return ToString.builder((String)"FecOutputSettings").add("ColumnDepth", (Object)this.columnDepth()).add("IncludeFec", (Object)this.includeFecAsString()).add("RowLength", (Object)this.rowLength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnDepth": {
                return Optional.of(clazz.cast(this.columnDepth()));
            }
            case "IncludeFec": {
                return Optional.of(clazz.cast(this.includeFecAsString()));
            }
            case "RowLength": {
                return Optional.of(clazz.cast(this.rowLength()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FecOutputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer columnDepth;
        private String includeFec;
        private Integer rowLength;

        private BuilderImpl() {
        }

        private BuilderImpl(FecOutputSettings model) {
            this.columnDepth(model.columnDepth);
            this.includeFec(model.includeFec);
            this.rowLength(model.rowLength);
        }

        public final Integer getColumnDepth() {
            return this.columnDepth;
        }

        @Override
        public final Builder columnDepth(Integer columnDepth) {
            this.columnDepth = columnDepth;
            return this;
        }

        public final void setColumnDepth(Integer columnDepth) {
            this.columnDepth = columnDepth;
        }

        public final String getIncludeFec() {
            return this.includeFec;
        }

        @Override
        public final Builder includeFec(String includeFec) {
            this.includeFec = includeFec;
            return this;
        }

        @Override
        public final Builder includeFec(FecOutputIncludeFec includeFec) {
            this.includeFec(includeFec.toString());
            return this;
        }

        public final void setIncludeFec(String includeFec) {
            this.includeFec = includeFec;
        }

        public final Integer getRowLength() {
            return this.rowLength;
        }

        @Override
        public final Builder rowLength(Integer rowLength) {
            this.rowLength = rowLength;
            return this;
        }

        public final void setRowLength(Integer rowLength) {
            this.rowLength = rowLength;
        }

        public FecOutputSettings build() {
            return new FecOutputSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FecOutputSettings> {
        public Builder columnDepth(Integer var1);

        public Builder includeFec(String var1);

        public Builder includeFec(FecOutputIncludeFec var1);

        public Builder rowLength(Integer var1);
    }
}

