/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.DvbSdtOutputSdt;
import software.amazon.awssdk.services.medialive.transform.DvbSdtSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DvbSdtSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, DvbSdtSettings> {
    private final String outputSdt;
    private final Integer repInterval;
    private final String serviceName;
    private final String serviceProviderName;

    private DvbSdtSettings(BuilderImpl builder) {
        this.outputSdt = builder.outputSdt;
        this.repInterval = builder.repInterval;
        this.serviceName = builder.serviceName;
        this.serviceProviderName = builder.serviceProviderName;
    }

    public DvbSdtOutputSdt outputSdt() {
        return DvbSdtOutputSdt.fromValue(this.outputSdt);
    }

    public String outputSdtAsString() {
        return this.outputSdt;
    }

    public Integer repInterval() {
        return this.repInterval;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceProviderName() {
        return this.serviceProviderName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSdtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProviderName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSdtSettings)) {
            return false;
        }
        DvbSdtSettings other = (DvbSdtSettings)obj;
        return Objects.equals(this.outputSdtAsString(), other.outputSdtAsString()) && Objects.equals(this.repInterval(), other.repInterval()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceProviderName(), other.serviceProviderName());
    }

    public String toString() {
        return ToString.builder((String)"DvbSdtSettings").add("OutputSdt", (Object)this.outputSdtAsString()).add("RepInterval", (Object)this.repInterval()).add("ServiceName", (Object)this.serviceName()).add("ServiceProviderName", (Object)this.serviceProviderName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputSdt": {
                return Optional.of(clazz.cast(this.outputSdtAsString()));
            }
            case "RepInterval": {
                return Optional.of(clazz.cast(this.repInterval()));
            }
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
            case "ServiceProviderName": {
                return Optional.of(clazz.cast(this.serviceProviderName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DvbSdtSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputSdt;
        private Integer repInterval;
        private String serviceName;
        private String serviceProviderName;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSdtSettings model) {
            this.outputSdt(model.outputSdt);
            this.repInterval(model.repInterval);
            this.serviceName(model.serviceName);
            this.serviceProviderName(model.serviceProviderName);
        }

        public final String getOutputSdt() {
            return this.outputSdt;
        }

        @Override
        public final Builder outputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
            return this;
        }

        @Override
        public final Builder outputSdt(DvbSdtOutputSdt outputSdt) {
            this.outputSdt(outputSdt.toString());
            return this;
        }

        public final void setOutputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
        }

        public final Integer getRepInterval() {
            return this.repInterval;
        }

        @Override
        public final Builder repInterval(Integer repInterval) {
            this.repInterval = repInterval;
            return this;
        }

        public final void setRepInterval(Integer repInterval) {
            this.repInterval = repInterval;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceProviderName() {
            return this.serviceProviderName;
        }

        @Override
        public final Builder serviceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
            return this;
        }

        public final void setServiceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
        }

        public DvbSdtSettings build() {
            return new DvbSdtSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DvbSdtSettings> {
        public Builder outputSdt(String var1);

        public Builder outputSdt(DvbSdtOutputSdt var1);

        public Builder repInterval(Integer var1);

        public Builder serviceName(String var1);

        public Builder serviceProviderName(String var1);
    }
}

