/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.medialive.model.InputDestinationRequest;
import software.amazon.awssdk.services.medialive.model.InputSourceRequest;
import software.amazon.awssdk.services.medialive.model.InputType;
import software.amazon.awssdk.services.medialive.model.ListOfInputDestinationRequestCopier;
import software.amazon.awssdk.services.medialive.model.ListOfInputSourceRequestCopier;
import software.amazon.awssdk.services.medialive.model.ListOf__stringCopier;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInputRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, CreateInputRequest> {
    private final List<InputDestinationRequest> destinations;
    private final List<String> inputSecurityGroups;
    private final String name;
    private final String requestId;
    private final List<InputSourceRequest> sources;
    private final String type;

    private CreateInputRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.name = builder.name;
        this.requestId = builder.requestId;
        this.sources = builder.sources;
        this.type = builder.type;
    }

    public List<InputDestinationRequest> destinations() {
        return this.destinations;
    }

    public List<String> inputSecurityGroups() {
        return this.inputSecurityGroups;
    }

    public String name() {
        return this.name;
    }

    public String requestId() {
        return this.requestId;
    }

    public List<InputSourceRequest> sources() {
        return this.sources;
    }

    public InputType type() {
        return InputType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sources());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInputRequest)) {
            return false;
        }
        CreateInputRequest other = (CreateInputRequest)((Object)obj);
        return Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.inputSecurityGroups(), other.inputSecurityGroups()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateInputRequest").add("Destinations", this.destinations()).add("InputSecurityGroups", this.inputSecurityGroups()).add("Name", (Object)this.name()).add("RequestId", (Object)this.requestId()).add("Sources", this.sources()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
            case "InputSecurityGroups": {
                return Optional.of(clazz.cast(this.inputSecurityGroups()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "RequestId": {
                return Optional.of(clazz.cast(this.requestId()));
            }
            case "Sources": {
                return Optional.of(clazz.cast(this.sources()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<InputDestinationRequest> destinations;
        private List<String> inputSecurityGroups;
        private String name;
        private String requestId;
        private List<InputSourceRequest> sources;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInputRequest model) {
            super(model);
            this.destinations(model.destinations);
            this.inputSecurityGroups(model.inputSecurityGroups);
            this.name(model.name);
            this.requestId(model.requestId);
            this.sources(model.sources);
            this.type(model.type);
        }

        public final Collection<InputDestinationRequest.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(InputDestinationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<InputDestinationRequest> destinations) {
            this.destinations = ListOfInputDestinationRequestCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestinationRequest ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestinationRequest.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (InputDestinationRequest)((InputDestinationRequest.Builder)InputDestinationRequest.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<InputDestinationRequest.BuilderImpl> destinations) {
            this.destinations = ListOfInputDestinationRequestCopier.copyFromBuilder(destinations);
        }

        public final Collection<String> getInputSecurityGroups() {
            return this.inputSecurityGroups;
        }

        @Override
        public final Builder inputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ListOf__stringCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(String ... inputSecurityGroups) {
            this.inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        public final void setInputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ListOf__stringCopier.copy(inputSecurityGroups);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Collection<InputSourceRequest.Builder> getSources() {
            return this.sources != null ? (Collection)this.sources.stream().map(InputSourceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<InputSourceRequest> sources) {
            this.sources = ListOfInputSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSourceRequest ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSourceRequest.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (InputSourceRequest)((InputSourceRequest.Builder)InputSourceRequest.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<InputSourceRequest.BuilderImpl> sources) {
            this.sources = ListOfInputSourceRequestCopier.copyFromBuilder(sources);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInputRequest build() {
            return new CreateInputRequest(this);
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    CopyableBuilder<Builder, CreateInputRequest> {
        public Builder destinations(Collection<InputDestinationRequest> var1);

        public Builder destinations(InputDestinationRequest ... var1);

        public Builder destinations(Consumer<InputDestinationRequest.Builder> ... var1);

        public Builder inputSecurityGroups(Collection<String> var1);

        public Builder inputSecurityGroups(String ... var1);

        public Builder name(String var1);

        public Builder requestId(String var1);

        public Builder sources(Collection<InputSourceRequest> var1);

        public Builder sources(InputSourceRequest ... var1);

        public Builder sources(Consumer<InputSourceRequest.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(InputType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

