/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.medialive.model.EncoderSettings;
import software.amazon.awssdk.services.medialive.model.InputAttachment;
import software.amazon.awssdk.services.medialive.model.ListOfInputAttachmentCopier;
import software.amazon.awssdk.services.medialive.model.ListOfOutputDestinationCopier;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateChannelRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, CreateChannelRequest> {
    private final List<OutputDestination> destinations;
    private final EncoderSettings encoderSettings;
    private final List<InputAttachment> inputAttachments;
    private final String name;
    private final String requestId;
    private final String reserved;
    private final String roleArn;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.encoderSettings = builder.encoderSettings;
        this.inputAttachments = builder.inputAttachments;
        this.name = builder.name;
        this.requestId = builder.requestId;
        this.reserved = builder.reserved;
        this.roleArn = builder.roleArn;
    }

    public List<OutputDestination> destinations() {
        return this.destinations;
    }

    public EncoderSettings encoderSettings() {
        return this.encoderSettings;
    }

    public List<InputAttachment> inputAttachments() {
        return this.inputAttachments;
    }

    public String name() {
        return this.name;
    }

    public String requestId() {
        return this.requestId;
    }

    public String reserved() {
        return this.reserved;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reserved());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)((Object)obj);
        return Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.encoderSettings(), other.encoderSettings()) && Objects.equals(this.inputAttachments(), other.inputAttachments()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.reserved(), other.reserved()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateChannelRequest").add("Destinations", this.destinations()).add("EncoderSettings", (Object)this.encoderSettings()).add("InputAttachments", this.inputAttachments()).add("Name", (Object)this.name()).add("RequestId", (Object)this.requestId()).add("Reserved", (Object)this.reserved()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
            case "EncoderSettings": {
                return Optional.of(clazz.cast(this.encoderSettings()));
            }
            case "InputAttachments": {
                return Optional.of(clazz.cast(this.inputAttachments()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "RequestId": {
                return Optional.of(clazz.cast(this.requestId()));
            }
            case "Reserved": {
                return Optional.of(clazz.cast(this.reserved()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<OutputDestination> destinations;
        private EncoderSettings encoderSettings;
        private List<InputAttachment> inputAttachments;
        private String name;
        private String requestId;
        private String reserved;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            this.destinations(model.destinations);
            this.encoderSettings(model.encoderSettings);
            this.inputAttachments(model.inputAttachments);
            this.name(model.name);
            this.requestId(model.requestId);
            this.reserved(model.reserved);
            this.roleArn(model.roleArn);
        }

        public final Collection<OutputDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(OutputDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ListOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (OutputDestination)((OutputDestination.Builder)OutputDestination.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ListOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return this.encoderSettings != null ? this.encoderSettings.toBuilder() : null;
        }

        @Override
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        public final Collection<InputAttachment.Builder> getInputAttachments() {
            return this.inputAttachments != null ? (Collection)this.inputAttachments.stream().map(InputAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ListOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment ... inputAttachments) {
            this.inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder> ... inputAttachments) {
            this.inputAttachments(Stream.of(inputAttachments).map(c -> (InputAttachment)((InputAttachment.Builder)InputAttachment.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ListOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getReserved() {
            return this.reserved;
        }

        @Override
        public final Builder reserved(String reserved) {
            this.reserved = reserved;
            return this;
        }

        public final void setReserved(String reserved) {
            this.reserved = reserved;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    CopyableBuilder<Builder, CreateChannelRequest> {
        public Builder destinations(Collection<OutputDestination> var1);

        public Builder destinations(OutputDestination ... var1);

        public Builder destinations(Consumer<OutputDestination.Builder> ... var1);

        public Builder encoderSettings(EncoderSettings var1);

        default public Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return this.encoderSettings((EncoderSettings)((EncoderSettings.Builder)EncoderSettings.builder().apply(encoderSettings)).build());
        }

        public Builder inputAttachments(Collection<InputAttachment> var1);

        public Builder inputAttachments(InputAttachment ... var1);

        public Builder inputAttachments(Consumer<InputAttachment.Builder> ... var1);

        public Builder name(String var1);

        public Builder requestId(String var1);

        public Builder reserved(String var1);

        public Builder roleArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

