/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint;
import software.amazon.awssdk.services.medialive.model.ChannelState;
import software.amazon.awssdk.services.medialive.model.EncoderSettings;
import software.amazon.awssdk.services.medialive.model.InputAttachment;
import software.amazon.awssdk.services.medialive.model.ListOfChannelEgressEndpointCopier;
import software.amazon.awssdk.services.medialive.model.ListOfInputAttachmentCopier;
import software.amazon.awssdk.services.medialive.model.ListOfOutputDestinationCopier;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.services.medialive.transform.ChannelMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Channel
implements StructuredPojo,
ToCopyableBuilder<Builder, Channel> {
    private final String arn;
    private final List<OutputDestination> destinations;
    private final List<ChannelEgressEndpoint> egressEndpoints;
    private final EncoderSettings encoderSettings;
    private final String id;
    private final List<InputAttachment> inputAttachments;
    private final String name;
    private final Integer pipelinesRunningCount;
    private final String roleArn;
    private final String state;

    private Channel(BuilderImpl builder) {
        this.arn = builder.arn;
        this.destinations = builder.destinations;
        this.egressEndpoints = builder.egressEndpoints;
        this.encoderSettings = builder.encoderSettings;
        this.id = builder.id;
        this.inputAttachments = builder.inputAttachments;
        this.name = builder.name;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
    }

    public String arn() {
        return this.arn;
    }

    public List<OutputDestination> destinations() {
        return this.destinations;
    }

    public List<ChannelEgressEndpoint> egressEndpoints() {
        return this.egressEndpoints;
    }

    public EncoderSettings encoderSettings() {
        return this.encoderSettings;
    }

    public String id() {
        return this.id;
    }

    public List<InputAttachment> inputAttachments() {
        return this.inputAttachments;
    }

    public String name() {
        return this.name;
    }

    public Integer pipelinesRunningCount() {
        return this.pipelinesRunningCount;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public ChannelState state() {
        return ChannelState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.egressEndpoints(), other.egressEndpoints()) && Objects.equals(this.encoderSettings(), other.encoderSettings()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.inputAttachments(), other.inputAttachments()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pipelinesRunningCount(), other.pipelinesRunningCount()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"Channel").add("Arn", (Object)this.arn()).add("Destinations", this.destinations()).add("EgressEndpoints", this.egressEndpoints()).add("EncoderSettings", (Object)this.encoderSettings()).add("Id", (Object)this.id()).add("InputAttachments", this.inputAttachments()).add("Name", (Object)this.name()).add("PipelinesRunningCount", (Object)this.pipelinesRunningCount()).add("RoleArn", (Object)this.roleArn()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
            case "EgressEndpoints": {
                return Optional.of(clazz.cast(this.egressEndpoints()));
            }
            case "EncoderSettings": {
                return Optional.of(clazz.cast(this.encoderSettings()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "InputAttachments": {
                return Optional.of(clazz.cast(this.inputAttachments()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "PipelinesRunningCount": {
                return Optional.of(clazz.cast(this.pipelinesRunningCount()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<OutputDestination> destinations;
        private List<ChannelEgressEndpoint> egressEndpoints;
        private EncoderSettings encoderSettings;
        private String id;
        private List<InputAttachment> inputAttachments;
        private String name;
        private Integer pipelinesRunningCount;
        private String roleArn;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            this.arn(model.arn);
            this.destinations(model.destinations);
            this.egressEndpoints(model.egressEndpoints);
            this.encoderSettings(model.encoderSettings);
            this.id(model.id);
            this.inputAttachments(model.inputAttachments);
            this.name(model.name);
            this.pipelinesRunningCount(model.pipelinesRunningCount);
            this.roleArn(model.roleArn);
            this.state(model.state);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<OutputDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(OutputDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ListOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (OutputDestination)((OutputDestination.Builder)OutputDestination.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ListOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        public final Collection<ChannelEgressEndpoint.Builder> getEgressEndpoints() {
            return this.egressEndpoints != null ? (Collection)this.egressEndpoints.stream().map(ChannelEgressEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder egressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints) {
            this.egressEndpoints = ListOfChannelEgressEndpointCopier.copy(egressEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(ChannelEgressEndpoint ... egressEndpoints) {
            this.egressEndpoints(Arrays.asList(egressEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder> ... egressEndpoints) {
            this.egressEndpoints(Stream.of(egressEndpoints).map(c -> (ChannelEgressEndpoint)((ChannelEgressEndpoint.Builder)ChannelEgressEndpoint.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEgressEndpoints(Collection<ChannelEgressEndpoint.BuilderImpl> egressEndpoints) {
            this.egressEndpoints = ListOfChannelEgressEndpointCopier.copyFromBuilder(egressEndpoints);
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return this.encoderSettings != null ? this.encoderSettings.toBuilder() : null;
        }

        @Override
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<InputAttachment.Builder> getInputAttachments() {
            return this.inputAttachments != null ? (Collection)this.inputAttachments.stream().map(InputAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ListOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment ... inputAttachments) {
            this.inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder> ... inputAttachments) {
            this.inputAttachments(Stream.of(inputAttachments).map(c -> (InputAttachment)((InputAttachment.Builder)InputAttachment.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ListOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPipelinesRunningCount() {
            return this.pipelinesRunningCount;
        }

        @Override
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ChannelState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public Channel build() {
            return new Channel(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Channel> {
        public Builder arn(String var1);

        public Builder destinations(Collection<OutputDestination> var1);

        public Builder destinations(OutputDestination ... var1);

        public Builder destinations(Consumer<OutputDestination.Builder> ... var1);

        public Builder egressEndpoints(Collection<ChannelEgressEndpoint> var1);

        public Builder egressEndpoints(ChannelEgressEndpoint ... var1);

        public Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder> ... var1);

        public Builder encoderSettings(EncoderSettings var1);

        default public Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return this.encoderSettings((EncoderSettings)((EncoderSettings.Builder)EncoderSettings.builder().apply(encoderSettings)).build());
        }

        public Builder id(String var1);

        public Builder inputAttachments(Collection<InputAttachment> var1);

        public Builder inputAttachments(InputAttachment ... var1);

        public Builder inputAttachments(Consumer<InputAttachment.Builder> ... var1);

        public Builder name(String var1);

        public Builder pipelinesRunningCount(Integer var1);

        public Builder roleArn(String var1);

        public Builder state(String var1);

        public Builder state(ChannelState var1);
    }
}

