/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.BlackoutSlateNetworkEndBlackout;
import software.amazon.awssdk.services.medialive.model.BlackoutSlateState;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.services.medialive.transform.BlackoutSlateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BlackoutSlate
implements StructuredPojo,
ToCopyableBuilder<Builder, BlackoutSlate> {
    private final InputLocation blackoutSlateImage;
    private final String networkEndBlackout;
    private final InputLocation networkEndBlackoutImage;
    private final String networkId;
    private final String state;

    private BlackoutSlate(BuilderImpl builder) {
        this.blackoutSlateImage = builder.blackoutSlateImage;
        this.networkEndBlackout = builder.networkEndBlackout;
        this.networkEndBlackoutImage = builder.networkEndBlackoutImage;
        this.networkId = builder.networkId;
        this.state = builder.state;
    }

    public InputLocation blackoutSlateImage() {
        return this.blackoutSlateImage;
    }

    public BlackoutSlateNetworkEndBlackout networkEndBlackout() {
        return BlackoutSlateNetworkEndBlackout.fromValue(this.networkEndBlackout);
    }

    public String networkEndBlackoutAsString() {
        return this.networkEndBlackout;
    }

    public InputLocation networkEndBlackoutImage() {
        return this.networkEndBlackoutImage;
    }

    public String networkId() {
        return this.networkId;
    }

    public BlackoutSlateState state() {
        return BlackoutSlateState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blackoutSlateImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkEndBlackoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkEndBlackoutImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlackoutSlate)) {
            return false;
        }
        BlackoutSlate other = (BlackoutSlate)obj;
        return Objects.equals(this.blackoutSlateImage(), other.blackoutSlateImage()) && Objects.equals(this.networkEndBlackoutAsString(), other.networkEndBlackoutAsString()) && Objects.equals(this.networkEndBlackoutImage(), other.networkEndBlackoutImage()) && Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"BlackoutSlate").add("BlackoutSlateImage", (Object)this.blackoutSlateImage()).add("NetworkEndBlackout", (Object)this.networkEndBlackoutAsString()).add("NetworkEndBlackoutImage", (Object)this.networkEndBlackoutImage()).add("NetworkId", (Object)this.networkId()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlackoutSlateImage": {
                return Optional.of(clazz.cast(this.blackoutSlateImage()));
            }
            case "NetworkEndBlackout": {
                return Optional.of(clazz.cast(this.networkEndBlackoutAsString()));
            }
            case "NetworkEndBlackoutImage": {
                return Optional.of(clazz.cast(this.networkEndBlackoutImage()));
            }
            case "NetworkId": {
                return Optional.of(clazz.cast(this.networkId()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlackoutSlateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private InputLocation blackoutSlateImage;
        private String networkEndBlackout;
        private InputLocation networkEndBlackoutImage;
        private String networkId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(BlackoutSlate model) {
            this.blackoutSlateImage(model.blackoutSlateImage);
            this.networkEndBlackout(model.networkEndBlackout);
            this.networkEndBlackoutImage(model.networkEndBlackoutImage);
            this.networkId(model.networkId);
            this.state(model.state);
        }

        public final InputLocation.Builder getBlackoutSlateImage() {
            return this.blackoutSlateImage != null ? this.blackoutSlateImage.toBuilder() : null;
        }

        @Override
        public final Builder blackoutSlateImage(InputLocation blackoutSlateImage) {
            this.blackoutSlateImage = blackoutSlateImage;
            return this;
        }

        public final void setBlackoutSlateImage(InputLocation.BuilderImpl blackoutSlateImage) {
            this.blackoutSlateImage = blackoutSlateImage != null ? blackoutSlateImage.build() : null;
        }

        public final String getNetworkEndBlackout() {
            return this.networkEndBlackout;
        }

        @Override
        public final Builder networkEndBlackout(String networkEndBlackout) {
            this.networkEndBlackout = networkEndBlackout;
            return this;
        }

        @Override
        public final Builder networkEndBlackout(BlackoutSlateNetworkEndBlackout networkEndBlackout) {
            this.networkEndBlackout(networkEndBlackout.toString());
            return this;
        }

        public final void setNetworkEndBlackout(String networkEndBlackout) {
            this.networkEndBlackout = networkEndBlackout;
        }

        public final InputLocation.Builder getNetworkEndBlackoutImage() {
            return this.networkEndBlackoutImage != null ? this.networkEndBlackoutImage.toBuilder() : null;
        }

        @Override
        public final Builder networkEndBlackoutImage(InputLocation networkEndBlackoutImage) {
            this.networkEndBlackoutImage = networkEndBlackoutImage;
            return this;
        }

        public final void setNetworkEndBlackoutImage(InputLocation.BuilderImpl networkEndBlackoutImage) {
            this.networkEndBlackoutImage = networkEndBlackoutImage != null ? networkEndBlackoutImage.build() : null;
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BlackoutSlateState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public BlackoutSlate build() {
            return new BlackoutSlate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlackoutSlate> {
        public Builder blackoutSlateImage(InputLocation var1);

        default public Builder blackoutSlateImage(Consumer<InputLocation.Builder> blackoutSlateImage) {
            return this.blackoutSlateImage((InputLocation)((InputLocation.Builder)InputLocation.builder().apply(blackoutSlateImage)).build());
        }

        public Builder networkEndBlackout(String var1);

        public Builder networkEndBlackout(BlackoutSlateNetworkEndBlackout var1);

        public Builder networkEndBlackoutImage(InputLocation var1);

        default public Builder networkEndBlackoutImage(Consumer<InputLocation.Builder> networkEndBlackoutImage) {
            return this.networkEndBlackoutImage((InputLocation)((InputLocation.Builder)InputLocation.builder().apply(networkEndBlackoutImage)).build());
        }

        public Builder networkId(String var1);

        public Builder state(String var1);

        public Builder state(BlackoutSlateState var1);
    }
}

