/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AvailBlankingState;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.services.medialive.transform.AvailBlankingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AvailBlanking
implements StructuredPojo,
ToCopyableBuilder<Builder, AvailBlanking> {
    private final InputLocation availBlankingImage;
    private final String state;

    private AvailBlanking(BuilderImpl builder) {
        this.availBlankingImage = builder.availBlankingImage;
        this.state = builder.state;
    }

    public InputLocation availBlankingImage() {
        return this.availBlankingImage;
    }

    public AvailBlankingState state() {
        return AvailBlankingState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availBlankingImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailBlanking)) {
            return false;
        }
        AvailBlanking other = (AvailBlanking)obj;
        return Objects.equals(this.availBlankingImage(), other.availBlankingImage()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"AvailBlanking").add("AvailBlankingImage", (Object)this.availBlankingImage()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailBlankingImage": {
                return Optional.of(clazz.cast(this.availBlankingImage()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AvailBlankingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private InputLocation availBlankingImage;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailBlanking model) {
            this.availBlankingImage(model.availBlankingImage);
            this.state(model.state);
        }

        public final InputLocation.Builder getAvailBlankingImage() {
            return this.availBlankingImage != null ? this.availBlankingImage.toBuilder() : null;
        }

        @Override
        public final Builder availBlankingImage(InputLocation availBlankingImage) {
            this.availBlankingImage = availBlankingImage;
            return this;
        }

        public final void setAvailBlankingImage(InputLocation.BuilderImpl availBlankingImage) {
            this.availBlankingImage = availBlankingImage != null ? availBlankingImage.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailBlankingState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public AvailBlanking build() {
            return new AvailBlanking(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AvailBlanking> {
        public Builder availBlankingImage(InputLocation var1);

        default public Builder availBlankingImage(Consumer<InputLocation.Builder> availBlankingImage) {
            return this.availBlankingImage((InputLocation)((InputLocation.Builder)InputLocation.builder().apply(availBlankingImage)).build());
        }

        public Builder state(String var1);

        public Builder state(AvailBlankingState var1);
    }
}

