/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy;
import software.amazon.awssdk.services.medialive.transform.AudioLanguageSelectionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AudioLanguageSelection
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioLanguageSelection> {
    private final String languageCode;
    private final String languageSelectionPolicy;

    private AudioLanguageSelection(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.languageSelectionPolicy = builder.languageSelectionPolicy;
    }

    public String languageCode() {
        return this.languageCode;
    }

    public AudioLanguageSelectionPolicy languageSelectionPolicy() {
        return AudioLanguageSelectionPolicy.fromValue(this.languageSelectionPolicy);
    }

    public String languageSelectionPolicyAsString() {
        return this.languageSelectionPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageSelectionPolicyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioLanguageSelection)) {
            return false;
        }
        AudioLanguageSelection other = (AudioLanguageSelection)obj;
        return Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.languageSelectionPolicyAsString(), other.languageSelectionPolicyAsString());
    }

    public String toString() {
        return ToString.builder((String)"AudioLanguageSelection").add("LanguageCode", (Object)this.languageCode()).add("LanguageSelectionPolicy", (Object)this.languageSelectionPolicyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.of(clazz.cast(this.languageCode()));
            }
            case "LanguageSelectionPolicy": {
                return Optional.of(clazz.cast(this.languageSelectionPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioLanguageSelectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private String languageSelectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioLanguageSelection model) {
            this.languageCode(model.languageCode);
            this.languageSelectionPolicy(model.languageSelectionPolicy);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageSelectionPolicy() {
            return this.languageSelectionPolicy;
        }

        @Override
        public final Builder languageSelectionPolicy(String languageSelectionPolicy) {
            this.languageSelectionPolicy = languageSelectionPolicy;
            return this;
        }

        @Override
        public final Builder languageSelectionPolicy(AudioLanguageSelectionPolicy languageSelectionPolicy) {
            this.languageSelectionPolicy(languageSelectionPolicy.toString());
            return this;
        }

        public final void setLanguageSelectionPolicy(String languageSelectionPolicy) {
            this.languageSelectionPolicy = languageSelectionPolicy;
        }

        public AudioLanguageSelection build() {
            return new AudioLanguageSelection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioLanguageSelection> {
        public Builder languageCode(String var1);

        public Builder languageSelectionPolicy(String var1);

        public Builder languageSelectionPolicy(AudioLanguageSelectionPolicy var1);
    }
}

