/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioCodecSettings;
import software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl;
import software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl;
import software.amazon.awssdk.services.medialive.model.AudioNormalizationSettings;
import software.amazon.awssdk.services.medialive.model.AudioType;
import software.amazon.awssdk.services.medialive.model.RemixSettings;
import software.amazon.awssdk.services.medialive.transform.AudioDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AudioDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioDescription> {
    private final AudioNormalizationSettings audioNormalizationSettings;
    private final String audioSelectorName;
    private final String audioType;
    private final String audioTypeControl;
    private final AudioCodecSettings codecSettings;
    private final String languageCode;
    private final String languageCodeControl;
    private final String name;
    private final RemixSettings remixSettings;
    private final String streamName;

    private AudioDescription(BuilderImpl builder) {
        this.audioNormalizationSettings = builder.audioNormalizationSettings;
        this.audioSelectorName = builder.audioSelectorName;
        this.audioType = builder.audioType;
        this.audioTypeControl = builder.audioTypeControl;
        this.codecSettings = builder.codecSettings;
        this.languageCode = builder.languageCode;
        this.languageCodeControl = builder.languageCodeControl;
        this.name = builder.name;
        this.remixSettings = builder.remixSettings;
        this.streamName = builder.streamName;
    }

    public AudioNormalizationSettings audioNormalizationSettings() {
        return this.audioNormalizationSettings;
    }

    public String audioSelectorName() {
        return this.audioSelectorName;
    }

    public AudioType audioType() {
        return AudioType.fromValue(this.audioType);
    }

    public String audioTypeAsString() {
        return this.audioType;
    }

    public AudioDescriptionAudioTypeControl audioTypeControl() {
        return AudioDescriptionAudioTypeControl.fromValue(this.audioTypeControl);
    }

    public String audioTypeControlAsString() {
        return this.audioTypeControl;
    }

    public AudioCodecSettings codecSettings() {
        return this.codecSettings;
    }

    public String languageCode() {
        return this.languageCode;
    }

    public AudioDescriptionLanguageCodeControl languageCodeControl() {
        return AudioDescriptionLanguageCodeControl.fromValue(this.languageCodeControl);
    }

    public String languageCodeControlAsString() {
        return this.languageCodeControl;
    }

    public String name() {
        return this.name;
    }

    public RemixSettings remixSettings() {
        return this.remixSettings;
    }

    public String streamName() {
        return this.streamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioNormalizationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTypeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioDescription)) {
            return false;
        }
        AudioDescription other = (AudioDescription)obj;
        return Objects.equals(this.audioNormalizationSettings(), other.audioNormalizationSettings()) && Objects.equals(this.audioSelectorName(), other.audioSelectorName()) && Objects.equals(this.audioTypeAsString(), other.audioTypeAsString()) && Objects.equals(this.audioTypeControlAsString(), other.audioTypeControlAsString()) && Objects.equals(this.codecSettings(), other.codecSettings()) && Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.languageCodeControlAsString(), other.languageCodeControlAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.remixSettings(), other.remixSettings()) && Objects.equals(this.streamName(), other.streamName());
    }

    public String toString() {
        return ToString.builder((String)"AudioDescription").add("AudioNormalizationSettings", (Object)this.audioNormalizationSettings()).add("AudioSelectorName", (Object)this.audioSelectorName()).add("AudioType", (Object)this.audioTypeAsString()).add("AudioTypeControl", (Object)this.audioTypeControlAsString()).add("CodecSettings", (Object)this.codecSettings()).add("LanguageCode", (Object)this.languageCode()).add("LanguageCodeControl", (Object)this.languageCodeControlAsString()).add("Name", (Object)this.name()).add("RemixSettings", (Object)this.remixSettings()).add("StreamName", (Object)this.streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioNormalizationSettings": {
                return Optional.of(clazz.cast(this.audioNormalizationSettings()));
            }
            case "AudioSelectorName": {
                return Optional.of(clazz.cast(this.audioSelectorName()));
            }
            case "AudioType": {
                return Optional.of(clazz.cast(this.audioTypeAsString()));
            }
            case "AudioTypeControl": {
                return Optional.of(clazz.cast(this.audioTypeControlAsString()));
            }
            case "CodecSettings": {
                return Optional.of(clazz.cast(this.codecSettings()));
            }
            case "LanguageCode": {
                return Optional.of(clazz.cast(this.languageCode()));
            }
            case "LanguageCodeControl": {
                return Optional.of(clazz.cast(this.languageCodeControlAsString()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "RemixSettings": {
                return Optional.of(clazz.cast(this.remixSettings()));
            }
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioNormalizationSettings audioNormalizationSettings;
        private String audioSelectorName;
        private String audioType;
        private String audioTypeControl;
        private AudioCodecSettings codecSettings;
        private String languageCode;
        private String languageCodeControl;
        private String name;
        private RemixSettings remixSettings;
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioDescription model) {
            this.audioNormalizationSettings(model.audioNormalizationSettings);
            this.audioSelectorName(model.audioSelectorName);
            this.audioType(model.audioType);
            this.audioTypeControl(model.audioTypeControl);
            this.codecSettings(model.codecSettings);
            this.languageCode(model.languageCode);
            this.languageCodeControl(model.languageCodeControl);
            this.name(model.name);
            this.remixSettings(model.remixSettings);
            this.streamName(model.streamName);
        }

        public final AudioNormalizationSettings.Builder getAudioNormalizationSettings() {
            return this.audioNormalizationSettings != null ? this.audioNormalizationSettings.toBuilder() : null;
        }

        @Override
        public final Builder audioNormalizationSettings(AudioNormalizationSettings audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings;
            return this;
        }

        public final void setAudioNormalizationSettings(AudioNormalizationSettings.BuilderImpl audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings != null ? audioNormalizationSettings.build() : null;
        }

        public final String getAudioSelectorName() {
            return this.audioSelectorName;
        }

        @Override
        public final Builder audioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
            return this;
        }

        public final void setAudioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
        }

        public final String getAudioType() {
            return this.audioType;
        }

        @Override
        public final Builder audioType(String audioType) {
            this.audioType = audioType;
            return this;
        }

        @Override
        public final Builder audioType(AudioType audioType) {
            this.audioType(audioType.toString());
            return this;
        }

        public final void setAudioType(String audioType) {
            this.audioType = audioType;
        }

        public final String getAudioTypeControl() {
            return this.audioTypeControl;
        }

        @Override
        public final Builder audioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
            return this;
        }

        @Override
        public final Builder audioTypeControl(AudioDescriptionAudioTypeControl audioTypeControl) {
            this.audioTypeControl(audioTypeControl.toString());
            return this;
        }

        public final void setAudioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
        }

        public final AudioCodecSettings.Builder getCodecSettings() {
            return this.codecSettings != null ? this.codecSettings.toBuilder() : null;
        }

        @Override
        public final Builder codecSettings(AudioCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final void setCodecSettings(AudioCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageCodeControl() {
            return this.languageCodeControl;
        }

        @Override
        public final Builder languageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
            return this;
        }

        @Override
        public final Builder languageCodeControl(AudioDescriptionLanguageCodeControl languageCodeControl) {
            this.languageCodeControl(languageCodeControl.toString());
            return this;
        }

        public final void setLanguageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return this.remixSettings != null ? this.remixSettings.toBuilder() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public AudioDescription build() {
            return new AudioDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioDescription> {
        public Builder audioNormalizationSettings(AudioNormalizationSettings var1);

        default public Builder audioNormalizationSettings(Consumer<AudioNormalizationSettings.Builder> audioNormalizationSettings) {
            return this.audioNormalizationSettings((AudioNormalizationSettings)((AudioNormalizationSettings.Builder)AudioNormalizationSettings.builder().apply(audioNormalizationSettings)).build());
        }

        public Builder audioSelectorName(String var1);

        public Builder audioType(String var1);

        public Builder audioType(AudioType var1);

        public Builder audioTypeControl(String var1);

        public Builder audioTypeControl(AudioDescriptionAudioTypeControl var1);

        public Builder codecSettings(AudioCodecSettings var1);

        default public Builder codecSettings(Consumer<AudioCodecSettings.Builder> codecSettings) {
            return this.codecSettings((AudioCodecSettings)((AudioCodecSettings.Builder)AudioCodecSettings.builder().apply(codecSettings)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCodeControl(String var1);

        public Builder languageCodeControl(AudioDescriptionLanguageCodeControl var1);

        public Builder name(String var1);

        public Builder remixSettings(RemixSettings var1);

        default public Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return this.remixSettings((RemixSettings)((RemixSettings.Builder)RemixSettings.builder().apply(remixSettings)).build());
        }

        public Builder streamName(String var1);
    }
}

