/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputChannelLevel;
import software.amazon.awssdk.services.medialive.model.ListOfInputChannelLevelCopier;
import software.amazon.awssdk.services.medialive.transform.AudioChannelMappingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AudioChannelMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioChannelMapping> {
    private final List<InputChannelLevel> inputChannelLevels;
    private final Integer outputChannel;

    private AudioChannelMapping(BuilderImpl builder) {
        this.inputChannelLevels = builder.inputChannelLevels;
        this.outputChannel = builder.outputChannel;
    }

    public List<InputChannelLevel> inputChannelLevels() {
        return this.inputChannelLevels;
    }

    public Integer outputChannel() {
        return this.outputChannel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputChannelLevels());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputChannel());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioChannelMapping)) {
            return false;
        }
        AudioChannelMapping other = (AudioChannelMapping)obj;
        return Objects.equals(this.inputChannelLevels(), other.inputChannelLevels()) && Objects.equals(this.outputChannel(), other.outputChannel());
    }

    public String toString() {
        return ToString.builder((String)"AudioChannelMapping").add("InputChannelLevels", this.inputChannelLevels()).add("OutputChannel", (Object)this.outputChannel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputChannelLevels": {
                return Optional.of(clazz.cast(this.inputChannelLevels()));
            }
            case "OutputChannel": {
                return Optional.of(clazz.cast(this.outputChannel()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioChannelMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InputChannelLevel> inputChannelLevels;
        private Integer outputChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioChannelMapping model) {
            this.inputChannelLevels(model.inputChannelLevels);
            this.outputChannel(model.outputChannel);
        }

        public final Collection<InputChannelLevel.Builder> getInputChannelLevels() {
            return this.inputChannelLevels != null ? (Collection)this.inputChannelLevels.stream().map(InputChannelLevel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputChannelLevels(Collection<InputChannelLevel> inputChannelLevels) {
            this.inputChannelLevels = ListOfInputChannelLevelCopier.copy(inputChannelLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannelLevels(InputChannelLevel ... inputChannelLevels) {
            this.inputChannelLevels(Arrays.asList(inputChannelLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannelLevels(Consumer<InputChannelLevel.Builder> ... inputChannelLevels) {
            this.inputChannelLevels(Stream.of(inputChannelLevels).map(c -> (InputChannelLevel)((InputChannelLevel.Builder)InputChannelLevel.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputChannelLevels(Collection<InputChannelLevel.BuilderImpl> inputChannelLevels) {
            this.inputChannelLevels = ListOfInputChannelLevelCopier.copyFromBuilder(inputChannelLevels);
        }

        public final Integer getOutputChannel() {
            return this.outputChannel;
        }

        @Override
        public final Builder outputChannel(Integer outputChannel) {
            this.outputChannel = outputChannel;
            return this;
        }

        public final void setOutputChannel(Integer outputChannel) {
            this.outputChannel = outputChannel;
        }

        public AudioChannelMapping build() {
            return new AudioChannelMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioChannelMapping> {
        public Builder inputChannelLevels(Collection<InputChannelLevel> var1);

        public Builder inputChannelLevels(InputChannelLevel ... var1);

        public Builder inputChannelLevels(Consumer<InputChannelLevel.Builder> ... var1);

        public Builder outputChannel(Integer var1);
    }
}

