/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode;
import software.amazon.awssdk.services.medialive.model.Ac3CodingMode;
import software.amazon.awssdk.services.medialive.model.Ac3DrcProfile;
import software.amazon.awssdk.services.medialive.model.Ac3LfeFilter;
import software.amazon.awssdk.services.medialive.model.Ac3MetadataControl;
import software.amazon.awssdk.services.medialive.transform.Ac3SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Ac3Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, Ac3Settings> {
    private final Double bitrate;
    private final String bitstreamMode;
    private final String codingMode;
    private final Integer dialnorm;
    private final String drcProfile;
    private final String lfeFilter;
    private final String metadataControl;

    private Ac3Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dialnorm = builder.dialnorm;
        this.drcProfile = builder.drcProfile;
        this.lfeFilter = builder.lfeFilter;
        this.metadataControl = builder.metadataControl;
    }

    public Double bitrate() {
        return this.bitrate;
    }

    public Ac3BitstreamMode bitstreamMode() {
        return Ac3BitstreamMode.fromValue(this.bitstreamMode);
    }

    public String bitstreamModeAsString() {
        return this.bitstreamMode;
    }

    public Ac3CodingMode codingMode() {
        return Ac3CodingMode.fromValue(this.codingMode);
    }

    public String codingModeAsString() {
        return this.codingMode;
    }

    public Integer dialnorm() {
        return this.dialnorm;
    }

    public Ac3DrcProfile drcProfile() {
        return Ac3DrcProfile.fromValue(this.drcProfile);
    }

    public String drcProfileAsString() {
        return this.drcProfile;
    }

    public Ac3LfeFilter lfeFilter() {
        return Ac3LfeFilter.fromValue(this.lfeFilter);
    }

    public String lfeFilterAsString() {
        return this.lfeFilter;
    }

    public Ac3MetadataControl metadataControl() {
        return Ac3MetadataControl.fromValue(this.metadataControl);
    }

    public String metadataControlAsString() {
        return this.metadataControl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(this.drcProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataControlAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ac3Settings)) {
            return false;
        }
        Ac3Settings other = (Ac3Settings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bitstreamModeAsString(), other.bitstreamModeAsString()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.dialnorm(), other.dialnorm()) && Objects.equals(this.drcProfileAsString(), other.drcProfileAsString()) && Objects.equals(this.lfeFilterAsString(), other.lfeFilterAsString()) && Objects.equals(this.metadataControlAsString(), other.metadataControlAsString());
    }

    public String toString() {
        return ToString.builder((String)"Ac3Settings").add("Bitrate", (Object)this.bitrate()).add("BitstreamMode", (Object)this.bitstreamModeAsString()).add("CodingMode", (Object)this.codingModeAsString()).add("Dialnorm", (Object)this.dialnorm()).add("DrcProfile", (Object)this.drcProfileAsString()).add("LfeFilter", (Object)this.lfeFilterAsString()).add("MetadataControl", (Object)this.metadataControlAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.of(clazz.cast(this.bitrate()));
            }
            case "BitstreamMode": {
                return Optional.of(clazz.cast(this.bitstreamModeAsString()));
            }
            case "CodingMode": {
                return Optional.of(clazz.cast(this.codingModeAsString()));
            }
            case "Dialnorm": {
                return Optional.of(clazz.cast(this.dialnorm()));
            }
            case "DrcProfile": {
                return Optional.of(clazz.cast(this.drcProfileAsString()));
            }
            case "LfeFilter": {
                return Optional.of(clazz.cast(this.lfeFilterAsString()));
            }
            case "MetadataControl": {
                return Optional.of(clazz.cast(this.metadataControlAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Ac3SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bitrate;
        private String bitstreamMode;
        private String codingMode;
        private Integer dialnorm;
        private String drcProfile;
        private String lfeFilter;
        private String metadataControl;

        private BuilderImpl() {
        }

        private BuilderImpl(Ac3Settings model) {
            this.bitrate(model.bitrate);
            this.bitstreamMode(model.bitstreamMode);
            this.codingMode(model.codingMode);
            this.dialnorm(model.dialnorm);
            this.drcProfile(model.drcProfile);
            this.lfeFilter(model.lfeFilter);
            this.metadataControl(model.metadataControl);
        }

        public final Double getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        public final String getBitstreamMode() {
            return this.bitstreamMode;
        }

        @Override
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        public final Builder bitstreamMode(Ac3BitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode.toString());
            return this;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Ac3CodingMode codingMode) {
            this.codingMode(codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final Integer getDialnorm() {
            return this.dialnorm;
        }

        @Override
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        public final String getDrcProfile() {
            return this.drcProfile;
        }

        @Override
        public final Builder drcProfile(String drcProfile) {
            this.drcProfile = drcProfile;
            return this;
        }

        @Override
        public final Builder drcProfile(Ac3DrcProfile drcProfile) {
            this.drcProfile(drcProfile.toString());
            return this;
        }

        public final void setDrcProfile(String drcProfile) {
            this.drcProfile = drcProfile;
        }

        public final String getLfeFilter() {
            return this.lfeFilter;
        }

        @Override
        public final Builder lfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
            return this;
        }

        @Override
        public final Builder lfeFilter(Ac3LfeFilter lfeFilter) {
            this.lfeFilter(lfeFilter.toString());
            return this;
        }

        public final void setLfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
        }

        public final String getMetadataControl() {
            return this.metadataControl;
        }

        @Override
        public final Builder metadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
            return this;
        }

        @Override
        public final Builder metadataControl(Ac3MetadataControl metadataControl) {
            this.metadataControl(metadataControl.toString());
            return this;
        }

        public final void setMetadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
        }

        public Ac3Settings build() {
            return new Ac3Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Ac3Settings> {
        public Builder bitrate(Double var1);

        public Builder bitstreamMode(String var1);

        public Builder bitstreamMode(Ac3BitstreamMode var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Ac3CodingMode var1);

        public Builder dialnorm(Integer var1);

        public Builder drcProfile(String var1);

        public Builder drcProfile(Ac3DrcProfile var1);

        public Builder lfeFilter(String var1);

        public Builder lfeFilter(Ac3LfeFilter var1);

        public Builder metadataControl(String var1);

        public Builder metadataControl(Ac3MetadataControl var1);
    }
}

