/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.config.AwsAsyncClientConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.model.BadGatewayException;
import software.amazon.awssdk.services.medialive.model.BadRequestException;
import software.amazon.awssdk.services.medialive.model.ConflictException;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.ForbiddenException;
import software.amazon.awssdk.services.medialive.model.GatewayTimeoutException;
import software.amazon.awssdk.services.medialive.model.InternalServerErrorException;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveException;
import software.amazon.awssdk.services.medialive.model.NotFoundException;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.TooManyRequestsException;
import software.amazon.awssdk.services.medialive.model.UnprocessableEntityException;
import software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher;
import software.amazon.awssdk.services.medialive.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateChannelResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputSecurityGroupResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteChannelResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputSecurityGroupResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeChannelResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputSecurityGroupResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListChannelsResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputSecurityGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputsResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.StartChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartChannelResponseUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.StopChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopChannelResponseUnmarshaller;

@SdkInternalApi
final class DefaultMediaLiveAsyncClient
implements MediaLiveAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultMediaLiveAsyncClient(AwsAsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "medialive";
    }

    @Override
    public CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChannelResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateChannelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createChannelRequest));
    }

    @Override
    public CompletableFuture<CreateInputResponse> createInput(CreateInputRequest createInputRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateInputResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateInputRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createInputRequest));
    }

    @Override
    public CompletableFuture<CreateInputSecurityGroupResponse> createInputSecurityGroup(CreateInputSecurityGroupRequest createInputSecurityGroupRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateInputSecurityGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateInputSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createInputSecurityGroupRequest));
    }

    @Override
    public CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteChannelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteChannelRequest));
    }

    @Override
    public CompletableFuture<DeleteInputResponse> deleteInput(DeleteInputRequest deleteInputRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInputResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteInputRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInputRequest));
    }

    @Override
    public CompletableFuture<DeleteInputSecurityGroupResponse> deleteInputSecurityGroup(DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInputSecurityGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteInputSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInputSecurityGroupRequest));
    }

    @Override
    public CompletableFuture<DescribeChannelResponse> describeChannel(DescribeChannelRequest describeChannelRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeChannelResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeChannelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeChannelRequest));
    }

    @Override
    public CompletableFuture<DescribeInputResponse> describeInput(DescribeInputRequest describeInputRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInputResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeInputRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInputRequest));
    }

    @Override
    public CompletableFuture<DescribeInputSecurityGroupResponse> describeInputSecurityGroup(DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInputSecurityGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeInputSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInputSecurityGroupRequest));
    }

    @Override
    public CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChannelsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListChannelsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listChannelsRequest));
    }

    @Override
    public ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        return new ListChannelsPublisher(this, listChannelsRequest);
    }

    @Override
    public CompletableFuture<ListInputSecurityGroupsResponse> listInputSecurityGroups(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInputSecurityGroupsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListInputSecurityGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInputSecurityGroupsRequest));
    }

    @Override
    public ListInputSecurityGroupsPublisher listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        return new ListInputSecurityGroupsPublisher(this, listInputSecurityGroupsRequest);
    }

    @Override
    public CompletableFuture<ListInputsResponse> listInputs(ListInputsRequest listInputsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInputsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListInputsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInputsRequest));
    }

    @Override
    public ListInputsPublisher listInputsPaginator(ListInputsRequest listInputsRequest) {
        return new ListInputsPublisher(this, listInputsRequest);
    }

    @Override
    public CompletableFuture<StartChannelResponse> startChannel(StartChannelRequest startChannelRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartChannelResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StartChannelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startChannelRequest));
    }

    @Override
    public CompletableFuture<StopChannelResponse> stopChannel(StopChannelRequest stopChannelRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopChannelResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new StopChannelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopChannelRequest));
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(MediaLiveException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadGatewayException").withModeledClass(BadGatewayException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(ConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnprocessableEntityException").withModeledClass(UnprocessableEntityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GatewayTimeoutException").withModeledClass(GatewayTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

