/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.DestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothAudioDeduplication;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothManifestEncoding;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MsSmoothGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MsSmoothGroupSettings> {
    private static final SdkField<String> AUDIO_DEDUPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::audioDeduplicationAsString)).setter(MsSmoothGroupSettings.setter(Builder::audioDeduplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDeduplication").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::destination)).setter(MsSmoothGroupSettings.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::destinationSettings)).setter(MsSmoothGroupSettings.setter(Builder::destinationSettings)).constructor(DestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<MsSmoothEncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::encryption)).setter(MsSmoothGroupSettings.setter(Builder::encryption)).constructor(MsSmoothEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::fragmentLength)).setter(MsSmoothGroupSettings.setter(Builder::fragmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()}).build();
    private static final SdkField<String> MANIFEST_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::manifestEncodingAsString)).setter(MsSmoothGroupSettings.setter(Builder::manifestEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestEncoding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DEDUPLICATION_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD, MANIFEST_ENCODING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioDeduplication;
    private final String destination;
    private final DestinationSettings destinationSettings;
    private final MsSmoothEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String manifestEncoding;

    private MsSmoothGroupSettings(BuilderImpl builder) {
        this.audioDeduplication = builder.audioDeduplication;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.manifestEncoding = builder.manifestEncoding;
    }

    public MsSmoothAudioDeduplication audioDeduplication() {
        return MsSmoothAudioDeduplication.fromValue(this.audioDeduplication);
    }

    public String audioDeduplicationAsString() {
        return this.audioDeduplication;
    }

    public String destination() {
        return this.destination;
    }

    public DestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public MsSmoothEncryptionSettings encryption() {
        return this.encryption;
    }

    public Integer fragmentLength() {
        return this.fragmentLength;
    }

    public MsSmoothManifestEncoding manifestEncoding() {
        return MsSmoothManifestEncoding.fromValue(this.manifestEncoding);
    }

    public String manifestEncodingAsString() {
        return this.manifestEncoding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDeduplicationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestEncodingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MsSmoothGroupSettings)) {
            return false;
        }
        MsSmoothGroupSettings other = (MsSmoothGroupSettings)obj;
        return Objects.equals(this.audioDeduplicationAsString(), other.audioDeduplicationAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.manifestEncodingAsString(), other.manifestEncodingAsString());
    }

    public String toString() {
        return ToString.builder((String)"MsSmoothGroupSettings").add("AudioDeduplication", (Object)this.audioDeduplicationAsString()).add("Destination", (Object)this.destination()).add("DestinationSettings", (Object)this.destinationSettings()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("ManifestEncoding", (Object)this.manifestEncodingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDeduplication": {
                return Optional.ofNullable(clazz.cast(this.audioDeduplicationAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "ManifestEncoding": {
                return Optional.ofNullable(clazz.cast(this.manifestEncodingAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MsSmoothGroupSettings, T> g) {
        return obj -> g.apply((MsSmoothGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioDeduplication;
        private String destination;
        private DestinationSettings destinationSettings;
        private MsSmoothEncryptionSettings encryption;
        private Integer fragmentLength;
        private String manifestEncoding;

        private BuilderImpl() {
        }

        private BuilderImpl(MsSmoothGroupSettings model) {
            this.audioDeduplication(model.audioDeduplication);
            this.destination(model.destination);
            this.destinationSettings(model.destinationSettings);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.manifestEncoding(model.manifestEncoding);
        }

        public final String getAudioDeduplicationAsString() {
            return this.audioDeduplication;
        }

        @Override
        public final Builder audioDeduplication(String audioDeduplication) {
            this.audioDeduplication = audioDeduplication;
            return this;
        }

        @Override
        public final Builder audioDeduplication(MsSmoothAudioDeduplication audioDeduplication) {
            this.audioDeduplication(audioDeduplication == null ? null : audioDeduplication.toString());
            return this;
        }

        public final void setAudioDeduplication(String audioDeduplication) {
            this.audioDeduplication = audioDeduplication;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final MsSmoothEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(MsSmoothEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(MsSmoothEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getManifestEncodingAsString() {
            return this.manifestEncoding;
        }

        @Override
        public final Builder manifestEncoding(String manifestEncoding) {
            this.manifestEncoding = manifestEncoding;
            return this;
        }

        @Override
        public final Builder manifestEncoding(MsSmoothManifestEncoding manifestEncoding) {
            this.manifestEncoding(manifestEncoding == null ? null : manifestEncoding.toString());
            return this;
        }

        public final void setManifestEncoding(String manifestEncoding) {
            this.manifestEncoding = manifestEncoding;
        }

        public MsSmoothGroupSettings build() {
            return new MsSmoothGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MsSmoothGroupSettings> {
        public Builder audioDeduplication(String var1);

        public Builder audioDeduplication(MsSmoothAudioDeduplication var1);

        public Builder destination(String var1);

        public Builder destinationSettings(DestinationSettings var1);

        default public Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((DestinationSettings)((DestinationSettings.Builder)DestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder encryption(MsSmoothEncryptionSettings var1);

        default public Builder encryption(Consumer<MsSmoothEncryptionSettings.Builder> encryption) {
            return this.encryption((MsSmoothEncryptionSettings)((MsSmoothEncryptionSettings.Builder)MsSmoothEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder manifestEncoding(String var1);

        public Builder manifestEncoding(MsSmoothManifestEncoding var1);
    }
}

