/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.services.mediaconvert.model.Order;
import software.amazon.awssdk.services.mediaconvert.model.PresetListBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPresetsRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, ListPresetsRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPresetsRequest.getter(ListPresetsRequest::category)).setter(ListPresetsRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("category").build()}).build();
    private static final SdkField<String> LIST_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPresetsRequest.getter(ListPresetsRequest::listByAsString)).setter(ListPresetsRequest.setter(Builder::listBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("listBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListPresetsRequest.getter(ListPresetsRequest::maxResults)).setter(ListPresetsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPresetsRequest.getter(ListPresetsRequest::nextToken)).setter(ListPresetsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPresetsRequest.getter(ListPresetsRequest::orderAsString)).setter(ListPresetsRequest.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("order").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, LIST_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_FIELD));
    private final String category;
    private final String listBy;
    private final Integer maxResults;
    private final String nextToken;
    private final String order;

    private ListPresetsRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.listBy = builder.listBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.order = builder.order;
    }

    public String category() {
        return this.category;
    }

    public PresetListBy listBy() {
        return PresetListBy.fromValue(this.listBy);
    }

    public String listByAsString() {
        return this.listBy;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Order order() {
        return Order.fromValue(this.order);
    }

    public String orderAsString() {
        return this.order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.listByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsRequest)) {
            return false;
        }
        ListPresetsRequest other = (ListPresetsRequest)((Object)obj);
        return Objects.equals(this.category(), other.category()) && Objects.equals(this.listByAsString(), other.listByAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.orderAsString(), other.orderAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListPresetsRequest").add("Category", (Object)this.category()).add("ListBy", (Object)this.listByAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Order", (Object)this.orderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "ListBy": {
                return Optional.ofNullable(clazz.cast(this.listByAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPresetsRequest, T> g) {
        return obj -> g.apply((ListPresetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private String category;
        private String listBy;
        private Integer maxResults;
        private String nextToken;
        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPresetsRequest model) {
            super(model);
            this.category(model.category);
            this.listBy(model.listBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.order(model.order);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getListByAsString() {
            return this.listBy;
        }

        @Override
        public final Builder listBy(String listBy) {
            this.listBy = listBy;
            return this;
        }

        @Override
        public final Builder listBy(PresetListBy listBy) {
            this.listBy(listBy == null ? null : listBy.toString());
            return this;
        }

        public final void setListBy(String listBy) {
            this.listBy = listBy;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOrderAsString() {
            return this.order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPresetsRequest build() {
            return new ListPresetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConvertRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPresetsRequest> {
        public Builder category(String var1);

        public Builder listBy(String var1);

        public Builder listBy(PresetListBy var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder order(String var1);

        public Builder order(Order var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

