/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSourceSettings;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptionSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaptionSelector> {
    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CaptionSelector.getter(CaptionSelector::customLanguageCode)).setter(CaptionSelector.setter(Builder::customLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CaptionSelector.getter(CaptionSelector::languageCodeAsString)).setter(CaptionSelector.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<CaptionSourceSettings> SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionSelector.getter(CaptionSelector::sourceSettings)).setter(CaptionSelector.setter(Builder::sourceSettings)).constructor(CaptionSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LANGUAGE_CODE_FIELD, LANGUAGE_CODE_FIELD, SOURCE_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customLanguageCode;
    private final String languageCode;
    private final CaptionSourceSettings sourceSettings;

    private CaptionSelector(BuilderImpl builder) {
        this.customLanguageCode = builder.customLanguageCode;
        this.languageCode = builder.languageCode;
        this.sourceSettings = builder.sourceSettings;
    }

    public String customLanguageCode() {
        return this.customLanguageCode;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public CaptionSourceSettings sourceSettings() {
        return this.sourceSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSelector)) {
            return false;
        }
        CaptionSelector other = (CaptionSelector)obj;
        return Objects.equals(this.customLanguageCode(), other.customLanguageCode()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.sourceSettings(), other.sourceSettings());
    }

    public String toString() {
        return ToString.builder((String)"CaptionSelector").add("CustomLanguageCode", (Object)this.customLanguageCode()).add("LanguageCode", (Object)this.languageCodeAsString()).add("SourceSettings", (Object)this.sourceSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.customLanguageCode()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "SourceSettings": {
                return Optional.ofNullable(clazz.cast(this.sourceSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionSelector, T> g) {
        return obj -> g.apply((CaptionSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customLanguageCode;
        private String languageCode;
        private CaptionSourceSettings sourceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSelector model) {
            this.customLanguageCode(model.customLanguageCode);
            this.languageCode(model.languageCode);
            this.sourceSettings(model.sourceSettings);
        }

        public final String getCustomLanguageCode() {
            return this.customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        public final String getLanguageCodeAsString() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final CaptionSourceSettings.Builder getSourceSettings() {
            return this.sourceSettings != null ? this.sourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder sourceSettings(CaptionSourceSettings sourceSettings) {
            this.sourceSettings = sourceSettings;
            return this;
        }

        public final void setSourceSettings(CaptionSourceSettings.BuilderImpl sourceSettings) {
            this.sourceSettings = sourceSettings != null ? sourceSettings.build() : null;
        }

        public CaptionSelector build() {
            return new CaptionSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaptionSelector> {
        public Builder customLanguageCode(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder sourceSettings(CaptionSourceSettings var1);

        default public Builder sourceSettings(Consumer<CaptionSourceSettings.Builder> sourceSettings) {
            return this.sourceSettings((CaptionSourceSettings)((CaptionSourceSettings.Builder)CaptionSourceSettings.builder().applyMutation(sourceSettings)).build());
        }
    }
}

