/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.MovClapAtom;
import software.amazon.awssdk.services.mediaconvert.model.MovCslgAtom;
import software.amazon.awssdk.services.mediaconvert.model.MovMpeg2FourCCControl;
import software.amazon.awssdk.services.mediaconvert.model.MovPaddingControl;
import software.amazon.awssdk.services.mediaconvert.model.MovReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MovSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MovSettings> {
    private static final SdkField<String> CLAP_ATOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MovSettings.getter(MovSettings::clapAtomAsString)).setter(MovSettings.setter(Builder::clapAtom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clapAtom").build()}).build();
    private static final SdkField<String> CSLG_ATOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MovSettings.getter(MovSettings::cslgAtomAsString)).setter(MovSettings.setter(Builder::cslgAtom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cslgAtom").build()}).build();
    private static final SdkField<String> MPEG2_FOUR_CC_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MovSettings.getter(MovSettings::mpeg2FourCCControlAsString)).setter(MovSettings.setter(Builder::mpeg2FourCCControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpeg2FourCCControl").build()}).build();
    private static final SdkField<String> PADDING_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MovSettings.getter(MovSettings::paddingControlAsString)).setter(MovSettings.setter(Builder::paddingControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paddingControl").build()}).build();
    private static final SdkField<String> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MovSettings.getter(MovSettings::referenceAsString)).setter(MovSettings.setter(Builder::reference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLAP_ATOM_FIELD, CSLG_ATOM_FIELD, MPEG2_FOUR_CC_CONTROL_FIELD, PADDING_CONTROL_FIELD, REFERENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clapAtom;
    private final String cslgAtom;
    private final String mpeg2FourCCControl;
    private final String paddingControl;
    private final String reference;

    private MovSettings(BuilderImpl builder) {
        this.clapAtom = builder.clapAtom;
        this.cslgAtom = builder.cslgAtom;
        this.mpeg2FourCCControl = builder.mpeg2FourCCControl;
        this.paddingControl = builder.paddingControl;
        this.reference = builder.reference;
    }

    public MovClapAtom clapAtom() {
        return MovClapAtom.fromValue(this.clapAtom);
    }

    public String clapAtomAsString() {
        return this.clapAtom;
    }

    public MovCslgAtom cslgAtom() {
        return MovCslgAtom.fromValue(this.cslgAtom);
    }

    public String cslgAtomAsString() {
        return this.cslgAtom;
    }

    public MovMpeg2FourCCControl mpeg2FourCCControl() {
        return MovMpeg2FourCCControl.fromValue(this.mpeg2FourCCControl);
    }

    public String mpeg2FourCCControlAsString() {
        return this.mpeg2FourCCControl;
    }

    public MovPaddingControl paddingControl() {
        return MovPaddingControl.fromValue(this.paddingControl);
    }

    public String paddingControlAsString() {
        return this.paddingControl;
    }

    public MovReference reference() {
        return MovReference.fromValue(this.reference);
    }

    public String referenceAsString() {
        return this.reference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clapAtomAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cslgAtomAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpeg2FourCCControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paddingControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MovSettings)) {
            return false;
        }
        MovSettings other = (MovSettings)obj;
        return Objects.equals(this.clapAtomAsString(), other.clapAtomAsString()) && Objects.equals(this.cslgAtomAsString(), other.cslgAtomAsString()) && Objects.equals(this.mpeg2FourCCControlAsString(), other.mpeg2FourCCControlAsString()) && Objects.equals(this.paddingControlAsString(), other.paddingControlAsString()) && Objects.equals(this.referenceAsString(), other.referenceAsString());
    }

    public String toString() {
        return ToString.builder((String)"MovSettings").add("ClapAtom", (Object)this.clapAtomAsString()).add("CslgAtom", (Object)this.cslgAtomAsString()).add("Mpeg2FourCCControl", (Object)this.mpeg2FourCCControlAsString()).add("PaddingControl", (Object)this.paddingControlAsString()).add("Reference", (Object)this.referenceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClapAtom": {
                return Optional.ofNullable(clazz.cast(this.clapAtomAsString()));
            }
            case "CslgAtom": {
                return Optional.ofNullable(clazz.cast(this.cslgAtomAsString()));
            }
            case "Mpeg2FourCCControl": {
                return Optional.ofNullable(clazz.cast(this.mpeg2FourCCControlAsString()));
            }
            case "PaddingControl": {
                return Optional.ofNullable(clazz.cast(this.paddingControlAsString()));
            }
            case "Reference": {
                return Optional.ofNullable(clazz.cast(this.referenceAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MovSettings, T> g) {
        return obj -> g.apply((MovSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clapAtom;
        private String cslgAtom;
        private String mpeg2FourCCControl;
        private String paddingControl;
        private String reference;

        private BuilderImpl() {
        }

        private BuilderImpl(MovSettings model) {
            this.clapAtom(model.clapAtom);
            this.cslgAtom(model.cslgAtom);
            this.mpeg2FourCCControl(model.mpeg2FourCCControl);
            this.paddingControl(model.paddingControl);
            this.reference(model.reference);
        }

        public final String getClapAtomAsString() {
            return this.clapAtom;
        }

        @Override
        public final Builder clapAtom(String clapAtom) {
            this.clapAtom = clapAtom;
            return this;
        }

        @Override
        public final Builder clapAtom(MovClapAtom clapAtom) {
            this.clapAtom(clapAtom.toString());
            return this;
        }

        public final void setClapAtom(String clapAtom) {
            this.clapAtom = clapAtom;
        }

        public final String getCslgAtomAsString() {
            return this.cslgAtom;
        }

        @Override
        public final Builder cslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
            return this;
        }

        @Override
        public final Builder cslgAtom(MovCslgAtom cslgAtom) {
            this.cslgAtom(cslgAtom.toString());
            return this;
        }

        public final void setCslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
        }

        public final String getMpeg2FourCCControlAsString() {
            return this.mpeg2FourCCControl;
        }

        @Override
        public final Builder mpeg2FourCCControl(String mpeg2FourCCControl) {
            this.mpeg2FourCCControl = mpeg2FourCCControl;
            return this;
        }

        @Override
        public final Builder mpeg2FourCCControl(MovMpeg2FourCCControl mpeg2FourCCControl) {
            this.mpeg2FourCCControl(mpeg2FourCCControl.toString());
            return this;
        }

        public final void setMpeg2FourCCControl(String mpeg2FourCCControl) {
            this.mpeg2FourCCControl = mpeg2FourCCControl;
        }

        public final String getPaddingControlAsString() {
            return this.paddingControl;
        }

        @Override
        public final Builder paddingControl(String paddingControl) {
            this.paddingControl = paddingControl;
            return this;
        }

        @Override
        public final Builder paddingControl(MovPaddingControl paddingControl) {
            this.paddingControl(paddingControl.toString());
            return this;
        }

        public final void setPaddingControl(String paddingControl) {
            this.paddingControl = paddingControl;
        }

        public final String getReferenceAsString() {
            return this.reference;
        }

        @Override
        public final Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public final Builder reference(MovReference reference) {
            this.reference(reference.toString());
            return this;
        }

        public final void setReference(String reference) {
            this.reference = reference;
        }

        public MovSettings build() {
            return new MovSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MovSettings> {
        public Builder clapAtom(String var1);

        public Builder clapAtom(MovClapAtom var1);

        public Builder cslgAtom(String var1);

        public Builder cslgAtom(MovCslgAtom var1);

        public Builder mpeg2FourCCControl(String var1);

        public Builder mpeg2FourCCControl(MovMpeg2FourCCControl var1);

        public Builder paddingControl(String var1);

        public Builder paddingControl(MovPaddingControl var1);

        public Builder reference(String var1);

        public Builder reference(MovReference var1);
    }
}

