/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.S3ServerSideEncryptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3EncryptionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3EncryptionSettings> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3EncryptionSettings.getter(S3EncryptionSettings::encryptionTypeAsString)).setter(S3EncryptionSettings.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3EncryptionSettings.getter(S3EncryptionSettings::kmsKeyArn)).setter(S3EncryptionSettings.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD, KMS_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String encryptionType;
    private final String kmsKeyArn;

    private S3EncryptionSettings(BuilderImpl builder) {
        this.encryptionType = builder.encryptionType;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public S3ServerSideEncryptionType encryptionType() {
        return S3ServerSideEncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3EncryptionSettings)) {
            return false;
        }
        S3EncryptionSettings other = (S3EncryptionSettings)obj;
        return Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"S3EncryptionSettings").add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3EncryptionSettings, T> g) {
        return obj -> g.apply((S3EncryptionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionType;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3EncryptionSettings model) {
            this.encryptionType(model.encryptionType);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getEncryptionTypeAsString() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(S3ServerSideEncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public S3EncryptionSettings build() {
            return new S3EncryptionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3EncryptionSettings> {
        public Builder encryptionType(String var1);

        public Builder encryptionType(S3ServerSideEncryptionType var1);

        public Builder kmsKeyArn(String var1);
    }
}

