/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HlsKeyProviderType {
    SPEKE("SPEKE"),
    STATIC_KEY("STATIC_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HlsKeyProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsKeyProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HlsKeyProviderType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsKeyProviderType> knownValues() {
        return Stream.of(HlsKeyProviderType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

