/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.services.mediaconvert.model.QueueStatus;
import software.amazon.awssdk.services.mediaconvert.model.ReservationPlanSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQueueRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, UpdateQueueRequest> {
    private static final SdkField<Integer> CONCURRENT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConcurrentJobs").getter(UpdateQueueRequest.getter(UpdateQueueRequest::concurrentJobs)).setter(UpdateQueueRequest.setter(Builder::concurrentJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentJobs").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateQueueRequest.getter(UpdateQueueRequest::description)).setter(UpdateQueueRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateQueueRequest.getter(UpdateQueueRequest::name)).setter(UpdateQueueRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<ReservationPlanSettings> RESERVATION_PLAN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReservationPlanSettings").getter(UpdateQueueRequest.getter(UpdateQueueRequest::reservationPlanSettings)).setter(UpdateQueueRequest.setter(Builder::reservationPlanSettings)).constructor(ReservationPlanSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationPlanSettings").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateQueueRequest.getter(UpdateQueueRequest::statusAsString)).setter(UpdateQueueRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONCURRENT_JOBS_FIELD, DESCRIPTION_FIELD, NAME_FIELD, RESERVATION_PLAN_SETTINGS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateQueueRequest.memberNameToFieldInitializer();
    private final Integer concurrentJobs;
    private final String description;
    private final String name;
    private final ReservationPlanSettings reservationPlanSettings;
    private final String status;

    private UpdateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.concurrentJobs = builder.concurrentJobs;
        this.description = builder.description;
        this.name = builder.name;
        this.reservationPlanSettings = builder.reservationPlanSettings;
        this.status = builder.status;
    }

    public final Integer concurrentJobs() {
        return this.concurrentJobs;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final ReservationPlanSettings reservationPlanSettings() {
        return this.reservationPlanSettings;
    }

    public final QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationPlanSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueRequest)) {
            return false;
        }
        UpdateQueueRequest other = (UpdateQueueRequest)((Object)obj);
        return Objects.equals(this.concurrentJobs(), other.concurrentJobs()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.reservationPlanSettings(), other.reservationPlanSettings()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQueueRequest").add("ConcurrentJobs", (Object)this.concurrentJobs()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("ReservationPlanSettings", (Object)this.reservationPlanSettings()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConcurrentJobs": {
                return Optional.ofNullable(clazz.cast(this.concurrentJobs()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ReservationPlanSettings": {
                return Optional.ofNullable(clazz.cast(this.reservationPlanSettings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("concurrentJobs", CONCURRENT_JOBS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("reservationPlanSettings", RESERVATION_PLAN_SETTINGS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueueRequest, T> g) {
        return obj -> g.apply((UpdateQueueRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private Integer concurrentJobs;
        private String description;
        private String name;
        private ReservationPlanSettings reservationPlanSettings;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueRequest model) {
            super(model);
            this.concurrentJobs(model.concurrentJobs);
            this.description(model.description);
            this.name(model.name);
            this.reservationPlanSettings(model.reservationPlanSettings);
            this.status(model.status);
        }

        public final Integer getConcurrentJobs() {
            return this.concurrentJobs;
        }

        public final void setConcurrentJobs(Integer concurrentJobs) {
            this.concurrentJobs = concurrentJobs;
        }

        @Override
        public final Builder concurrentJobs(Integer concurrentJobs) {
            this.concurrentJobs = concurrentJobs;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ReservationPlanSettings.Builder getReservationPlanSettings() {
            return this.reservationPlanSettings != null ? this.reservationPlanSettings.toBuilder() : null;
        }

        public final void setReservationPlanSettings(ReservationPlanSettings.BuilderImpl reservationPlanSettings) {
            this.reservationPlanSettings = reservationPlanSettings != null ? reservationPlanSettings.build() : null;
        }

        @Override
        public final Builder reservationPlanSettings(ReservationPlanSettings reservationPlanSettings) {
            this.reservationPlanSettings = reservationPlanSettings;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueRequest build() {
            return new UpdateQueueRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConvertRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQueueRequest> {
        public Builder concurrentJobs(Integer var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder reservationPlanSettings(ReservationPlanSettings var1);

        default public Builder reservationPlanSettings(Consumer<ReservationPlanSettings.Builder> reservationPlanSettings) {
            return this.reservationPlanSettings((ReservationPlanSettings)((ReservationPlanSettings.Builder)ReservationPlanSettings.builder().applyMutation(reservationPlanSettings)).build());
        }

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

