/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.services.mediaconvert.model.ProbeInputFile;
import software.amazon.awssdk.services.mediaconvert.model.___listOfProbeInputFileCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProbeRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, ProbeRequest> {
    private static final SdkField<List<ProbeInputFile>> INPUT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputFiles").getter(ProbeRequest.getter(ProbeRequest::inputFiles)).setter(ProbeRequest.setter(Builder::inputFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProbeInputFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProbeRequest.memberNameToFieldInitializer();
    private final List<ProbeInputFile> inputFiles;

    private ProbeRequest(BuilderImpl builder) {
        super(builder);
        this.inputFiles = builder.inputFiles;
    }

    public final boolean hasInputFiles() {
        return this.inputFiles != null && !(this.inputFiles instanceof SdkAutoConstructList);
    }

    public final List<ProbeInputFile> inputFiles() {
        return this.inputFiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputFiles() ? this.inputFiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProbeRequest)) {
            return false;
        }
        ProbeRequest other = (ProbeRequest)((Object)obj);
        return this.hasInputFiles() == other.hasInputFiles() && Objects.equals(this.inputFiles(), other.inputFiles());
    }

    public final String toString() {
        return ToString.builder((String)"ProbeRequest").add("InputFiles", this.hasInputFiles() ? this.inputFiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputFiles": {
                return Optional.ofNullable(clazz.cast(this.inputFiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ProbeInputFile>>> map = new HashMap<String, SdkField<List<ProbeInputFile>>>();
        map.put("inputFiles", INPUT_FILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProbeRequest, T> g) {
        return obj -> g.apply((ProbeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private List<ProbeInputFile> inputFiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProbeRequest model) {
            super(model);
            this.inputFiles(model.inputFiles);
        }

        public final List<ProbeInputFile.Builder> getInputFiles() {
            List<ProbeInputFile.Builder> result = ___listOfProbeInputFileCopier.copyToBuilder(this.inputFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputFiles(Collection<ProbeInputFile.BuilderImpl> inputFiles) {
            this.inputFiles = ___listOfProbeInputFileCopier.copyFromBuilder(inputFiles);
        }

        @Override
        public final Builder inputFiles(Collection<ProbeInputFile> inputFiles) {
            this.inputFiles = ___listOfProbeInputFileCopier.copy(inputFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputFiles(ProbeInputFile ... inputFiles) {
            this.inputFiles(Arrays.asList(inputFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputFiles(Consumer<ProbeInputFile.Builder> ... inputFiles) {
            this.inputFiles(Stream.of(inputFiles).map(c -> (ProbeInputFile)((ProbeInputFile.Builder)ProbeInputFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProbeRequest build() {
            return new ProbeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConvertRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProbeRequest> {
        public Builder inputFiles(Collection<ProbeInputFile> var1);

        public Builder inputFiles(ProbeInputFile ... var1);

        public Builder inputFiles(Consumer<ProbeInputFile.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

