/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.Job;
import software.amazon.awssdk.services.mediaconvert.model.JobsQueryStatus;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertResponse;
import software.amazon.awssdk.services.mediaconvert.model.___listOfJobCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobsQueryResultsResponse
extends MediaConvertResponse
implements ToCopyableBuilder<Builder, GetJobsQueryResultsResponse> {
    private static final SdkField<List<Job>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Jobs").getter(GetJobsQueryResultsResponse.getter(GetJobsQueryResultsResponse::jobs)).setter(GetJobsQueryResultsResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Job::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetJobsQueryResultsResponse.getter(GetJobsQueryResultsResponse::nextToken)).setter(GetJobsQueryResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetJobsQueryResultsResponse.getter(GetJobsQueryResultsResponse::statusAsString)).setter(GetJobsQueryResultsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetJobsQueryResultsResponse.memberNameToFieldInitializer();
    private final List<Job> jobs;
    private final String nextToken;
    private final String status;

    private GetJobsQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
    }

    public final boolean hasJobs() {
        return this.jobs != null && !(this.jobs instanceof SdkAutoConstructList);
    }

    public final List<Job> jobs() {
        return this.jobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final JobsQueryStatus status() {
        return JobsQueryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobs() ? this.jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobsQueryResultsResponse)) {
            return false;
        }
        GetJobsQueryResultsResponse other = (GetJobsQueryResultsResponse)((Object)obj);
        return this.hasJobs() == other.hasJobs() && Objects.equals(this.jobs(), other.jobs()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetJobsQueryResultsResponse").add("Jobs", this.hasJobs() ? this.jobs() : null).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobs", JOBS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobsQueryResultsResponse, T> g) {
        return obj -> g.apply((GetJobsQueryResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConvertResponse.BuilderImpl
    implements Builder {
        private List<Job> jobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobsQueryResultsResponse model) {
            super(model);
            this.jobs(model.jobs);
            this.nextToken(model.nextToken);
            this.status(model.status);
        }

        public final List<Job.Builder> getJobs() {
            List<Job.Builder> result = ___listOfJobCopier.copyToBuilder(this.jobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobs(Collection<Job.BuilderImpl> jobs) {
            this.jobs = ___listOfJobCopier.copyFromBuilder(jobs);
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = ___listOfJobCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<Job.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (Job)((Job.Builder)Job.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobsQueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetJobsQueryResultsResponse build() {
            return new GetJobsQueryResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConvertResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobsQueryResultsResponse> {
        public Builder jobs(Collection<Job> var1);

        public Builder jobs(Job ... var1);

        public Builder jobs(Consumer<Job.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder status(String var1);

        public Builder status(JobsQueryStatus var1);
    }
}

