/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.FrameRate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioProperties> {
    private static final SdkField<Integer> BIT_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BitDepth").getter(AudioProperties.getter(AudioProperties::bitDepth)).setter(AudioProperties.setter(Builder::bitDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitDepth").build()}).build();
    private static final SdkField<Long> BIT_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BitRate").getter(AudioProperties.getter(AudioProperties::bitRate)).setter(AudioProperties.setter(Builder::bitRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitRate").build()}).build();
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Channels").getter(AudioProperties.getter(AudioProperties::channels)).setter(AudioProperties.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final SdkField<FrameRate> FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameRate").getter(AudioProperties.getter(AudioProperties::frameRate)).setter(AudioProperties.setter(Builder::frameRate)).constructor(FrameRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameRate").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(AudioProperties.getter(AudioProperties::languageCode)).setter(AudioProperties.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleRate").getter(AudioProperties.getter(AudioProperties::sampleRate)).setter(AudioProperties.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIT_DEPTH_FIELD, BIT_RATE_FIELD, CHANNELS_FIELD, FRAME_RATE_FIELD, LANGUAGE_CODE_FIELD, SAMPLE_RATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudioProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer bitDepth;
    private final Long bitRate;
    private final Integer channels;
    private final FrameRate frameRate;
    private final String languageCode;
    private final Integer sampleRate;

    private AudioProperties(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.bitRate = builder.bitRate;
        this.channels = builder.channels;
        this.frameRate = builder.frameRate;
        this.languageCode = builder.languageCode;
        this.sampleRate = builder.sampleRate;
    }

    public final Integer bitDepth() {
        return this.bitDepth;
    }

    public final Long bitRate() {
        return this.bitRate;
    }

    public final Integer channels() {
        return this.channels;
    }

    public final FrameRate frameRate() {
        return this.frameRate;
    }

    public final String languageCode() {
        return this.languageCode;
    }

    public final Integer sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioProperties)) {
            return false;
        }
        AudioProperties other = (AudioProperties)obj;
        return Objects.equals(this.bitDepth(), other.bitDepth()) && Objects.equals(this.bitRate(), other.bitRate()) && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.frameRate(), other.frameRate()) && Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public final String toString() {
        return ToString.builder((String)"AudioProperties").add("BitDepth", (Object)this.bitDepth()).add("BitRate", (Object)this.bitRate()).add("Channels", (Object)this.channels()).add("FrameRate", (Object)this.frameRate()).add("LanguageCode", (Object)this.languageCode()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitDepth": {
                return Optional.ofNullable(clazz.cast(this.bitDepth()));
            }
            case "BitRate": {
                return Optional.ofNullable(clazz.cast(this.bitRate()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "FrameRate": {
                return Optional.ofNullable(clazz.cast(this.frameRate()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bitDepth", BIT_DEPTH_FIELD);
        map.put("bitRate", BIT_RATE_FIELD);
        map.put("channels", CHANNELS_FIELD);
        map.put("frameRate", FRAME_RATE_FIELD);
        map.put("languageCode", LANGUAGE_CODE_FIELD);
        map.put("sampleRate", SAMPLE_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioProperties, T> g) {
        return obj -> g.apply((AudioProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitDepth;
        private Long bitRate;
        private Integer channels;
        private FrameRate frameRate;
        private String languageCode;
        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioProperties model) {
            this.bitDepth(model.bitDepth);
            this.bitRate(model.bitRate);
            this.channels(model.channels);
            this.frameRate(model.frameRate);
            this.languageCode(model.languageCode);
            this.sampleRate(model.sampleRate);
        }

        public final Integer getBitDepth() {
            return this.bitDepth;
        }

        public final void setBitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
        }

        @Override
        public final Builder bitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final Long getBitRate() {
            return this.bitRate;
        }

        public final void setBitRate(Long bitRate) {
            this.bitRate = bitRate;
        }

        @Override
        public final Builder bitRate(Long bitRate) {
            this.bitRate = bitRate;
            return this;
        }

        public final Integer getChannels() {
            return this.channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final FrameRate.Builder getFrameRate() {
            return this.frameRate != null ? this.frameRate.toBuilder() : null;
        }

        public final void setFrameRate(FrameRate.BuilderImpl frameRate) {
            this.frameRate = frameRate != null ? frameRate.build() : null;
        }

        @Override
        public final Builder frameRate(FrameRate frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public AudioProperties build() {
            return new AudioProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioProperties> {
        public Builder bitDepth(Integer var1);

        public Builder bitRate(Long var1);

        public Builder channels(Integer var1);

        public Builder frameRate(FrameRate var1);

        default public Builder frameRate(Consumer<FrameRate.Builder> frameRate) {
            return this.frameRate((FrameRate)((FrameRate.Builder)FrameRate.builder().applyMutation(frameRate)).build());
        }

        public Builder languageCode(String var1);

        public Builder sampleRate(Integer var1);
    }
}

