/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse;
import software.amazon.awssdk.services.mediaconvert.model.Queue;

public class ListQueuesIterable
implements SdkIterable<ListQueuesResponse> {
    private final MediaConvertClient client;
    private final ListQueuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueuesIterable(MediaConvertClient client, ListQueuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListQueuesResponseFetcher();
    }

    public Iterator<ListQueuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Queue> queues() {
        Function<ListQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.queues() != null) {
                return response.queues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListQueuesIterable resume(ListQueuesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListQueuesIterable(this.client, (ListQueuesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListQueuesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListQueuesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListQueuesResponseFetcher
    implements SyncPageFetcher<ListQueuesResponse> {
        private ListQueuesResponseFetcher() {
        }

        public boolean hasNextPage(ListQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueuesResponse nextPage(ListQueuesResponse previousPage) {
            if (previousPage == null) {
                return ListQueuesIterable.this.client.listQueues(ListQueuesIterable.this.firstRequest);
            }
            return ListQueuesIterable.this.client.listQueues((ListQueuesRequest)((Object)ListQueuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

