/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmfcAudioDuration;
import software.amazon.awssdk.services.mediaconvert.model.Mp4C2paManifest;
import software.amazon.awssdk.services.mediaconvert.model.Mp4CslgAtom;
import software.amazon.awssdk.services.mediaconvert.model.Mp4FreeSpaceBox;
import software.amazon.awssdk.services.mediaconvert.model.Mp4MoovPlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mp4Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mp4Settings> {
    private static final SdkField<String> AUDIO_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioDuration").getter(Mp4Settings.getter(Mp4Settings::audioDurationAsString)).setter(Mp4Settings.setter(Builder::audioDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDuration").build()}).build();
    private static final SdkField<String> C2_PA_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("C2paManifest").getter(Mp4Settings.getter(Mp4Settings::c2paManifestAsString)).setter(Mp4Settings.setter(Builder::c2paManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("c2paManifest").build()}).build();
    private static final SdkField<String> CERTIFICATE_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateSecret").getter(Mp4Settings.getter(Mp4Settings::certificateSecret)).setter(Mp4Settings.setter(Builder::certificateSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateSecret").build()}).build();
    private static final SdkField<String> CSLG_ATOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CslgAtom").getter(Mp4Settings.getter(Mp4Settings::cslgAtomAsString)).setter(Mp4Settings.setter(Builder::cslgAtom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cslgAtom").build()}).build();
    private static final SdkField<Integer> CTTS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CttsVersion").getter(Mp4Settings.getter(Mp4Settings::cttsVersion)).setter(Mp4Settings.setter(Builder::cttsVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cttsVersion").build()}).build();
    private static final SdkField<String> FREE_SPACE_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FreeSpaceBox").getter(Mp4Settings.getter(Mp4Settings::freeSpaceBoxAsString)).setter(Mp4Settings.setter(Builder::freeSpaceBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeSpaceBox").build()}).build();
    private static final SdkField<String> MOOV_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MoovPlacement").getter(Mp4Settings.getter(Mp4Settings::moovPlacementAsString)).setter(Mp4Settings.setter(Builder::moovPlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moovPlacement").build()}).build();
    private static final SdkField<String> MP4_MAJOR_BRAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mp4MajorBrand").getter(Mp4Settings.getter(Mp4Settings::mp4MajorBrand)).setter(Mp4Settings.setter(Builder::mp4MajorBrand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp4MajorBrand").build()}).build();
    private static final SdkField<String> SIGNING_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningKmsKey").getter(Mp4Settings.getter(Mp4Settings::signingKmsKey)).setter(Mp4Settings.setter(Builder::signingKmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingKmsKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DURATION_FIELD, C2_PA_MANIFEST_FIELD, CERTIFICATE_SECRET_FIELD, CSLG_ATOM_FIELD, CTTS_VERSION_FIELD, FREE_SPACE_BOX_FIELD, MOOV_PLACEMENT_FIELD, MP4_MAJOR_BRAND_FIELD, SIGNING_KMS_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Mp4Settings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String audioDuration;
    private final String c2paManifest;
    private final String certificateSecret;
    private final String cslgAtom;
    private final Integer cttsVersion;
    private final String freeSpaceBox;
    private final String moovPlacement;
    private final String mp4MajorBrand;
    private final String signingKmsKey;

    private Mp4Settings(BuilderImpl builder) {
        this.audioDuration = builder.audioDuration;
        this.c2paManifest = builder.c2paManifest;
        this.certificateSecret = builder.certificateSecret;
        this.cslgAtom = builder.cslgAtom;
        this.cttsVersion = builder.cttsVersion;
        this.freeSpaceBox = builder.freeSpaceBox;
        this.moovPlacement = builder.moovPlacement;
        this.mp4MajorBrand = builder.mp4MajorBrand;
        this.signingKmsKey = builder.signingKmsKey;
    }

    public final CmfcAudioDuration audioDuration() {
        return CmfcAudioDuration.fromValue(this.audioDuration);
    }

    public final String audioDurationAsString() {
        return this.audioDuration;
    }

    public final Mp4C2paManifest c2paManifest() {
        return Mp4C2paManifest.fromValue(this.c2paManifest);
    }

    public final String c2paManifestAsString() {
        return this.c2paManifest;
    }

    public final String certificateSecret() {
        return this.certificateSecret;
    }

    public final Mp4CslgAtom cslgAtom() {
        return Mp4CslgAtom.fromValue(this.cslgAtom);
    }

    public final String cslgAtomAsString() {
        return this.cslgAtom;
    }

    public final Integer cttsVersion() {
        return this.cttsVersion;
    }

    public final Mp4FreeSpaceBox freeSpaceBox() {
        return Mp4FreeSpaceBox.fromValue(this.freeSpaceBox);
    }

    public final String freeSpaceBoxAsString() {
        return this.freeSpaceBox;
    }

    public final Mp4MoovPlacement moovPlacement() {
        return Mp4MoovPlacement.fromValue(this.moovPlacement);
    }

    public final String moovPlacementAsString() {
        return this.moovPlacement;
    }

    public final String mp4MajorBrand() {
        return this.mp4MajorBrand;
    }

    public final String signingKmsKey() {
        return this.signingKmsKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.c2paManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.cslgAtomAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cttsVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeSpaceBoxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.moovPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp4MajorBrand());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingKmsKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp4Settings)) {
            return false;
        }
        Mp4Settings other = (Mp4Settings)obj;
        return Objects.equals(this.audioDurationAsString(), other.audioDurationAsString()) && Objects.equals(this.c2paManifestAsString(), other.c2paManifestAsString()) && Objects.equals(this.certificateSecret(), other.certificateSecret()) && Objects.equals(this.cslgAtomAsString(), other.cslgAtomAsString()) && Objects.equals(this.cttsVersion(), other.cttsVersion()) && Objects.equals(this.freeSpaceBoxAsString(), other.freeSpaceBoxAsString()) && Objects.equals(this.moovPlacementAsString(), other.moovPlacementAsString()) && Objects.equals(this.mp4MajorBrand(), other.mp4MajorBrand()) && Objects.equals(this.signingKmsKey(), other.signingKmsKey());
    }

    public final String toString() {
        return ToString.builder((String)"Mp4Settings").add("AudioDuration", (Object)this.audioDurationAsString()).add("C2paManifest", (Object)this.c2paManifestAsString()).add("CertificateSecret", (Object)this.certificateSecret()).add("CslgAtom", (Object)this.cslgAtomAsString()).add("CttsVersion", (Object)this.cttsVersion()).add("FreeSpaceBox", (Object)this.freeSpaceBoxAsString()).add("MoovPlacement", (Object)this.moovPlacementAsString()).add("Mp4MajorBrand", (Object)this.mp4MajorBrand()).add("SigningKmsKey", (Object)this.signingKmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDuration": {
                return Optional.ofNullable(clazz.cast(this.audioDurationAsString()));
            }
            case "C2paManifest": {
                return Optional.ofNullable(clazz.cast(this.c2paManifestAsString()));
            }
            case "CertificateSecret": {
                return Optional.ofNullable(clazz.cast(this.certificateSecret()));
            }
            case "CslgAtom": {
                return Optional.ofNullable(clazz.cast(this.cslgAtomAsString()));
            }
            case "CttsVersion": {
                return Optional.ofNullable(clazz.cast(this.cttsVersion()));
            }
            case "FreeSpaceBox": {
                return Optional.ofNullable(clazz.cast(this.freeSpaceBoxAsString()));
            }
            case "MoovPlacement": {
                return Optional.ofNullable(clazz.cast(this.moovPlacementAsString()));
            }
            case "Mp4MajorBrand": {
                return Optional.ofNullable(clazz.cast(this.mp4MajorBrand()));
            }
            case "SigningKmsKey": {
                return Optional.ofNullable(clazz.cast(this.signingKmsKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("audioDuration", AUDIO_DURATION_FIELD);
        map.put("c2paManifest", C2_PA_MANIFEST_FIELD);
        map.put("certificateSecret", CERTIFICATE_SECRET_FIELD);
        map.put("cslgAtom", CSLG_ATOM_FIELD);
        map.put("cttsVersion", CTTS_VERSION_FIELD);
        map.put("freeSpaceBox", FREE_SPACE_BOX_FIELD);
        map.put("moovPlacement", MOOV_PLACEMENT_FIELD);
        map.put("mp4MajorBrand", MP4_MAJOR_BRAND_FIELD);
        map.put("signingKmsKey", SIGNING_KMS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mp4Settings, T> g) {
        return obj -> g.apply((Mp4Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioDuration;
        private String c2paManifest;
        private String certificateSecret;
        private String cslgAtom;
        private Integer cttsVersion;
        private String freeSpaceBox;
        private String moovPlacement;
        private String mp4MajorBrand;
        private String signingKmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp4Settings model) {
            this.audioDuration(model.audioDuration);
            this.c2paManifest(model.c2paManifest);
            this.certificateSecret(model.certificateSecret);
            this.cslgAtom(model.cslgAtom);
            this.cttsVersion(model.cttsVersion);
            this.freeSpaceBox(model.freeSpaceBox);
            this.moovPlacement(model.moovPlacement);
            this.mp4MajorBrand(model.mp4MajorBrand);
            this.signingKmsKey(model.signingKmsKey);
        }

        public final String getAudioDuration() {
            return this.audioDuration;
        }

        public final void setAudioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
        }

        @Override
        public final Builder audioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public final Builder audioDuration(CmfcAudioDuration audioDuration) {
            this.audioDuration(audioDuration == null ? null : audioDuration.toString());
            return this;
        }

        public final String getC2paManifest() {
            return this.c2paManifest;
        }

        public final void setC2paManifest(String c2paManifest) {
            this.c2paManifest = c2paManifest;
        }

        @Override
        public final Builder c2paManifest(String c2paManifest) {
            this.c2paManifest = c2paManifest;
            return this;
        }

        @Override
        public final Builder c2paManifest(Mp4C2paManifest c2paManifest) {
            this.c2paManifest(c2paManifest == null ? null : c2paManifest.toString());
            return this;
        }

        public final String getCertificateSecret() {
            return this.certificateSecret;
        }

        public final void setCertificateSecret(String certificateSecret) {
            this.certificateSecret = certificateSecret;
        }

        @Override
        public final Builder certificateSecret(String certificateSecret) {
            this.certificateSecret = certificateSecret;
            return this;
        }

        public final String getCslgAtom() {
            return this.cslgAtom;
        }

        public final void setCslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
        }

        @Override
        public final Builder cslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
            return this;
        }

        @Override
        public final Builder cslgAtom(Mp4CslgAtom cslgAtom) {
            this.cslgAtom(cslgAtom == null ? null : cslgAtom.toString());
            return this;
        }

        public final Integer getCttsVersion() {
            return this.cttsVersion;
        }

        public final void setCttsVersion(Integer cttsVersion) {
            this.cttsVersion = cttsVersion;
        }

        @Override
        public final Builder cttsVersion(Integer cttsVersion) {
            this.cttsVersion = cttsVersion;
            return this;
        }

        public final String getFreeSpaceBox() {
            return this.freeSpaceBox;
        }

        public final void setFreeSpaceBox(String freeSpaceBox) {
            this.freeSpaceBox = freeSpaceBox;
        }

        @Override
        public final Builder freeSpaceBox(String freeSpaceBox) {
            this.freeSpaceBox = freeSpaceBox;
            return this;
        }

        @Override
        public final Builder freeSpaceBox(Mp4FreeSpaceBox freeSpaceBox) {
            this.freeSpaceBox(freeSpaceBox == null ? null : freeSpaceBox.toString());
            return this;
        }

        public final String getMoovPlacement() {
            return this.moovPlacement;
        }

        public final void setMoovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
        }

        @Override
        public final Builder moovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
            return this;
        }

        @Override
        public final Builder moovPlacement(Mp4MoovPlacement moovPlacement) {
            this.moovPlacement(moovPlacement == null ? null : moovPlacement.toString());
            return this;
        }

        public final String getMp4MajorBrand() {
            return this.mp4MajorBrand;
        }

        public final void setMp4MajorBrand(String mp4MajorBrand) {
            this.mp4MajorBrand = mp4MajorBrand;
        }

        @Override
        public final Builder mp4MajorBrand(String mp4MajorBrand) {
            this.mp4MajorBrand = mp4MajorBrand;
            return this;
        }

        public final String getSigningKmsKey() {
            return this.signingKmsKey;
        }

        public final void setSigningKmsKey(String signingKmsKey) {
            this.signingKmsKey = signingKmsKey;
        }

        @Override
        public final Builder signingKmsKey(String signingKmsKey) {
            this.signingKmsKey = signingKmsKey;
            return this;
        }

        public Mp4Settings build() {
            return new Mp4Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mp4Settings> {
        public Builder audioDuration(String var1);

        public Builder audioDuration(CmfcAudioDuration var1);

        public Builder c2paManifest(String var1);

        public Builder c2paManifest(Mp4C2paManifest var1);

        public Builder certificateSecret(String var1);

        public Builder cslgAtom(String var1);

        public Builder cslgAtom(Mp4CslgAtom var1);

        public Builder cttsVersion(Integer var1);

        public Builder freeSpaceBox(String var1);

        public Builder freeSpaceBox(Mp4FreeSpaceBox var1);

        public Builder moovPlacement(String var1);

        public Builder moovPlacement(Mp4MoovPlacement var1);

        public Builder mp4MajorBrand(String var1);

        public Builder signingKmsKey(String var1);
    }
}

